/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.util.common.impl.Futures;

class HibernateSearchSessionFactoryObserver
implements SessionFactoryObserver {
    private final CompletableFuture<SessionFactoryImplementor> sessionFactoryCreatedFuture;
    private final CompletableFuture<?> sessionFactoryClosingFuture;
    private final CompletableFuture<?> contextFuture;

    HibernateSearchSessionFactoryObserver(CompletableFuture<SessionFactoryImplementor> sessionFactoryCreatedFuture, CompletableFuture<?> sessionFactoryClosingFuture, CompletableFuture<?> contextFuture) {
        this.sessionFactoryCreatedFuture = sessionFactoryCreatedFuture;
        this.sessionFactoryClosingFuture = sessionFactoryClosingFuture;
        this.contextFuture = contextFuture;
    }

    public synchronized void sessionFactoryCreated(SessionFactory factory) {
        SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)factory;
        this.sessionFactoryCreatedFuture.complete(sessionFactoryImplementor);
        if (this.contextFuture.isCompletedExceptionally()) {
            Futures.unwrappedExceptionJoin(this.contextFuture);
        }
    }

    public synchronized void sessionFactoryClosing(SessionFactory factory) {
        this.sessionFactoryClosingFuture.complete(null);
    }
}

