/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.index.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.index.DocumentRefreshStrategy;
import org.hibernate.search.util.common.impl.Futures;

public interface AutomaticIndexingSynchronizationStrategy {
    public DocumentCommitStrategy getDocumentCommitStrategy();

    public DocumentRefreshStrategy getDocumentRefreshStrategy();

    public void handleFuture(CompletableFuture<?> var1);

    public static AutomaticIndexingSynchronizationStrategy queued() {
        return new AutomaticIndexingSynchronizationStrategy(){

            @Override
            public DocumentCommitStrategy getDocumentCommitStrategy() {
                return DocumentCommitStrategy.NONE;
            }

            @Override
            public DocumentRefreshStrategy getDocumentRefreshStrategy() {
                return DocumentRefreshStrategy.NONE;
            }

            @Override
            public void handleFuture(CompletableFuture<?> future) {
            }
        };
    }

    public static AutomaticIndexingSynchronizationStrategy committed() {
        return new AutomaticIndexingSynchronizationStrategy(){

            @Override
            public DocumentCommitStrategy getDocumentCommitStrategy() {
                return DocumentCommitStrategy.FORCE;
            }

            @Override
            public DocumentRefreshStrategy getDocumentRefreshStrategy() {
                return DocumentRefreshStrategy.NONE;
            }

            @Override
            public void handleFuture(CompletableFuture<?> future) {
                Futures.unwrappedExceptionJoin(future);
            }
        };
    }

    public static AutomaticIndexingSynchronizationStrategy searchable() {
        return new AutomaticIndexingSynchronizationStrategy(){

            @Override
            public DocumentCommitStrategy getDocumentCommitStrategy() {
                return DocumentCommitStrategy.FORCE;
            }

            @Override
            public DocumentRefreshStrategy getDocumentRefreshStrategy() {
                return DocumentRefreshStrategy.FORCE;
            }

            @Override
            public void handleFuture(CompletableFuture<?> future) {
                Futures.unwrappedExceptionJoin(future);
            }
        };
    }
}

