/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.query.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Optional;
import javax.persistence.TypedQuery;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.query.Query;
import org.hibernate.search.engine.search.query.spi.IndexSearchQuery;
import org.hibernate.search.engine.search.query.spi.IndexSearchResult;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableObjectLoadingOptions;
import org.hibernate.search.mapper.orm.search.query.SearchQuery;
import org.hibernate.search.mapper.orm.search.query.SearchResult;
import org.hibernate.search.mapper.orm.search.query.impl.HibernateOrmSearchQueryAdapter;
import org.hibernate.search.mapper.orm.search.query.impl.HibernateOrmSearchResult;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class HibernateOrmSearchQuery<R>
implements SearchQuery<R> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexSearchQuery<R> delegate;
    private final SessionImplementor sessionImplementor;
    private final MutableObjectLoadingOptions loadingOptions;
    private HibernateOrmSearchQueryAdapter<R> adapter;

    public HibernateOrmSearchQuery(IndexSearchQuery<R> delegate, SessionImplementor sessionImplementor, MutableObjectLoadingOptions loadingOptions) {
        this.delegate = delegate;
        this.sessionImplementor = sessionImplementor;
        this.loadingOptions = loadingOptions;
    }

    public String toString() {
        return "HibernateOrmSearchQuery(" + this.delegate.getQueryString() + ")";
    }

    @Override
    public TypedQuery<R> toJpaQuery() {
        return this.toOrmQuery();
    }

    @Override
    public Query<R> toOrmQuery() {
        if (this.adapter == null) {
            this.adapter = new HibernateOrmSearchQueryAdapter(this, this.sessionImplementor);
        }
        return this.adapter;
    }

    @Override
    public SearchResult<R> fetch(Long limit, Long offset) {
        return this.doFetch(limit, offset);
    }

    @Override
    public List<R> fetchHits(Long limit, Long offset) {
        return this.fetch(limit, offset).getHits();
    }

    @Override
    public long fetchTotalHitCount() {
        return this.delegate.fetchTotalHitCount();
    }

    @Override
    public Optional<R> fetchSingleHit() {
        SearchResult result = this.fetch(2L);
        List hits = result.getHits();
        int fetchedHitCount = result.getHits().size();
        if (fetchedHitCount == 0) {
            return Optional.empty();
        }
        if (fetchedHitCount > 1) {
            throw log.nonSingleHit(result.getTotalHitCount());
        }
        return Optional.of(hits.get(0));
    }

    @Override
    public HibernateOrmSearchQuery<R> setFetchSize(int fetchSize) {
        this.loadingOptions.setFetchSize(fetchSize);
        return this;
    }

    IndexSearchQuery<R> getIndexSearchQuery() {
        return this.delegate;
    }

    String getQueryString() {
        return this.delegate.getQueryString();
    }

    private SearchResult<R> doFetch(Long limit, Long offset) {
        IndexSearchResult results = this.delegate.fetch(limit, offset);
        return new HibernateOrmSearchResult(results);
    }
}

