/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.logging.impl;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.hibernate.mapping.Value;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractor;
import org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;

@MessageLogger(projectCode="HSEARCH")
@ValidIdRanges(value={@ValidIdRange(min=800000, max=809999), @ValidIdRange(min=27, max=28), @ValidIdRange(min=30, max=31), @ValidIdRange(min=36, max=36), @ValidIdRange(min=62, max=62), @ValidIdRange(min=65, max=65), @ValidIdRange(min=116, max=116), @ValidIdRange(min=183, max=183), @ValidIdRange(min=211, max=212), @ValidIdRange(min=276, max=276), @ValidIdRange(min=348, max=349)})
public interface Log
extends BasicLogger {
    public static final int ID_OFFSET_1 = 0;
    public static final int ID_OFFSET_2 = 800000;

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=27, value="Going to reindex %d entities")
    public void indexingEntities(long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=28, value="Reindexed %1$d entities")
    public void indexingEntitiesCompleted(long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=30, value="%1$d documents indexed in %2$d ms")
    public void indexingDocumentsCompleted(long var1, long var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=31, value="Indexing speed: %1$f documents/second; progress: %2$.2f%%")
    public void indexingSpeed(float var1, float var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=36, value="Cannot guess the Transaction Status: not starting a JTA transaction")
    public void cannotGuessTransactionStatus(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=62, value="Batch indexing was interrupted")
    public void interruptedBatchIndexing();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=65, value="Error while rolling back transaction after %1$s")
    public void errorRollingBackTransaction(String var1, @Cause Exception var2);

    @Message(id=116, value="Unexpected error during MassIndexer operation")
    public String massIndexerUnexpectedErrorMessage();

    @Message(id=183, value="Unable to index instance of type %s while batch indexing: %s")
    public String massIndexerUnableToIndexInstance(String var1, String var2);

    @Message(id=211, value="An exception occurred while the MassIndexer was fetching the primary identifiers list")
    public String massIndexerExceptionWhileFetchingIds();

    @Message(id=212, value="An exception occurred while the MassIndexer was transforming identifiers to Lucene Documents")
    public String massIndexerExceptionWhileTransformingIds();

    @Message(id=276, value="No transaction is active while indexing entity type '%1$s'; Consider increasing the connection time-out")
    public SearchException transactionNotActiveWhileProducingIdsForBatchIndexing(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=348, value="Some of the specified entity types ('%s') are not configured, nor is any of their subclasses.")
    public IllegalArgumentException someTargetedEntityTypesNotConfigured(String var1);

    @Message(id=349, value="Some of the specified entity types ('%s') are not indexed, nor is any of their subclasses.")
    public IllegalArgumentException someTargetedEntityTypesNotIndexed(String var1);

    @Message(id=800001, value="Hibernate Search was not initialized.")
    public SearchException hibernateSearchNotInitialized();

    @Message(id=800002, value="Unexpected entity type for a query hit: %1$s. Expected one of %2$s.")
    public SearchException unexpectedSearchHitType(Class<?> var1, Collection<? extends Class<?>> var2);

    @Message(id=800003, value="Invalid indexing strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidIndexingStrategyName(String var1, List<String> var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=800005, value="Configuration property tracking is disabled; unused properties will not be logged.")
    public void configurationPropertyTrackingDisabled();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=800006, value="Some properties in the Hibernate Search configuration were not used; there might be misspelled property keys in your configuration. Unused properties were: %1$s. To disable this warning, set the property '%2$s' to false.")
    public void configurationPropertyTrackingUnusedProperties(Set<String> var1, String var2);

    @Message(id=800007, value="Path '%2$s' on entity type '%1$s' cannot be resolved using Hibernate ORM metadata. Please check that this path points to a persisted value.")
    public SearchException unknownPathForDirtyChecking(Class<?> var1, PojoModelPath var2, @Cause Exception var3);

    @Message(id=800008, value="Path '%2$s' on entity type '%1$s' can be resolved using Hibernate ORM metadata, but points to value '%3$s' that will never be reported as dirty by Hibernate ORM. Please check that this path points to a persisted value, and in particular not an embedded property.")
    public SearchException unreportedPathForDirtyChecking(Class<?> var1, PojoModelPath var2, Value var3);

    @Message(id=800009, value="Container value extractor of type '%2$s' cannot be applied to Hibernate ORM metadata node of type '%1$s'.")
    public SearchException invalidContainerExtractorForDirtyChecking(Class<?> var1, Class<? extends ContainerExtractor> var2);

    @Message(id=800010, value="Unable to find a readable property '%2$s' on type '%1$s'.")
    public SearchException cannotFindReadableProperty(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, String var2);

    @Message(id=800011, value="Mapping service cannot create a SearchSession using a different session factory. Expected: '%1$s'. In use: '%2$s'.")
    public SearchException usingDifferentSessionFactories(SessionFactory var1, SessionFactory var2);

    @Message(id=800012, value="Exception while retrieving property type model for '%1$s' on '%2$s'.")
    public SearchException errorRetrievingPropertyTypeModel(String var1, @FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var2, @Cause Exception var3);

    @Message(id=800013, value="Interrupted on batch Indexing; index will be left in unknown state!")
    public SearchException interruptedBatchIndexingException(@Cause Exception var1);

    @Message(id=800014, value="Multiple hits when a single hit was expected: got %1$s hits.")
    public SearchException nonSingleHit(long var1);

    @Message(id=800015, value="Invalid property handle factory name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidPropertyHandleFactoryName(String var1, List<String> var2);
}

