/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import java.util.Collection;
import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.mapper.orm.mapping.context.impl.HibernateOrmMappingContextImpl;
import org.hibernate.search.mapper.orm.massindexing.MassIndexer;
import org.hibernate.search.mapper.orm.massindexing.impl.MassIndexerImpl;
import org.hibernate.search.mapper.orm.search.SearchScope;
import org.hibernate.search.mapper.orm.search.impl.SearchScopeImpl;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.hibernate.search.mapper.orm.session.context.impl.HibernateOrmSessionContextImpl;
import org.hibernate.search.mapper.orm.session.spi.SearchSessionBuilder;
import org.hibernate.search.mapper.orm.session.spi.SearchSessionImplementor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.search.spi.PojoSearchScopeDelegate;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.mapper.pojo.session.spi.AbstractPojoSearchSession;
import org.hibernate.search.mapper.pojo.work.spi.PojoSessionWorkExecutor;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkPlan;

public class HibernateOrmSearchSession
extends AbstractPojoSearchSession
implements SearchSessionImplementor,
SearchSession {
    private final SessionImplementor sessionImplementor;

    private HibernateOrmSearchSession(HibernateOrmSearchSessionBuilder builder) {
        super((AbstractPojoSearchSession.AbstractBuilder)builder);
        this.sessionImplementor = builder.sessionImplementor;
    }

    @Override
    public void close() {
    }

    @Override
    public EntityManager toEntityManager() {
        return this.sessionImplementor;
    }

    @Override
    public Session toOrmSession() {
        return this.sessionImplementor;
    }

    @Override
    public <T> SearchScope<T> scope(Collection<? extends Class<? extends T>> types) {
        PojoSearchScopeDelegate searchScopeDelegate = this.getDelegate().createPojoSearchScope(types);
        return new SearchScopeImpl(searchScopeDelegate, this.sessionImplementor);
    }

    @Override
    public MassIndexer createIndexer(Class<?> ... types) {
        if (types.length == 0) {
            types = new Class[]{Object.class};
        }
        return new MassIndexerImpl(this.sessionImplementor.getFactory(), this.sessionImplementor.getTenantIdentifier(), types);
    }

    @Override
    public PojoWorkPlan createWorkPlan() {
        return this.getDelegate().createWorkPlan();
    }

    @Override
    public PojoSessionWorkExecutor createSessionWorkExecutor() {
        return this.getDelegate().createSessionWorkExecutor();
    }

    public static class HibernateOrmSearchSessionBuilder
    extends AbstractPojoSearchSession.AbstractBuilder<HibernateOrmSearchSession>
    implements SearchSessionBuilder {
        private final HibernateOrmMappingContextImpl mappingContext;
        private final SessionImplementor sessionImplementor;

        public HibernateOrmSearchSessionBuilder(PojoMappingDelegate mappingDelegate, HibernateOrmMappingContextImpl mappingContext, SessionImplementor sessionImplementor) {
            super(mappingDelegate);
            this.mappingContext = mappingContext;
            this.sessionImplementor = sessionImplementor;
        }

        protected AbstractPojoSessionContextImplementor buildSessionContext() {
            return new HibernateOrmSessionContextImpl(this.mappingContext, this.sessionImplementor);
        }

        @Override
        public HibernateOrmSearchSession build() {
            return new HibernateOrmSearchSession(this);
        }
    }
}

