/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.dsl.query.impl;

import java.util.List;
import java.util.function.Function;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryContext;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionTerminalContext;
import org.hibernate.search.engine.search.dsl.query.SearchQueryResultContext;
import org.hibernate.search.mapper.orm.search.dsl.query.SearchQueryResultDefinitionContext;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableObjectLoadingOptions;
import org.hibernate.search.mapper.orm.search.loading.impl.ObjectLoaderBuilder;
import org.hibernate.search.mapper.orm.search.query.SearchQuery;
import org.hibernate.search.mapper.orm.search.query.impl.HibernateOrmSearchQuery;
import org.hibernate.search.mapper.pojo.search.PojoReference;
import org.hibernate.search.mapper.pojo.search.spi.PojoSearchScopeDelegate;

public class SearchQueryResultDefinitionContextImpl<O>
implements SearchQueryResultDefinitionContext<O> {
    private final PojoSearchScopeDelegate<O, O> searchScopeDelegate;
    private final SessionImplementor sessionImplementor;
    private final ObjectLoaderBuilder<O> objectLoaderBuilder;

    public SearchQueryResultDefinitionContextImpl(PojoSearchScopeDelegate<O, O> searchScopeDelegate, SessionImplementor sessionImplementor) {
        this.searchScopeDelegate = searchScopeDelegate;
        this.sessionImplementor = sessionImplementor;
        this.objectLoaderBuilder = new ObjectLoaderBuilder((Session)sessionImplementor, searchScopeDelegate.getIncludedIndexedTypes());
    }

    @Override
    public SearchQueryResultContext<? extends SearchQuery<O>> asEntity() {
        MutableObjectLoadingOptions loadingOptions = new MutableObjectLoadingOptions();
        return this.searchScopeDelegate.queryAsLoadedObject(this.objectLoaderBuilder.build(loadingOptions), q -> new HibernateOrmSearchQuery(q, this.sessionImplementor, loadingOptions));
    }

    @Override
    public <T> SearchQueryResultContext<? extends SearchQuery<T>> asProjection(SearchProjection<T> projection) {
        MutableObjectLoadingOptions loadingOptions = new MutableObjectLoadingOptions();
        return this.searchScopeDelegate.queryAsProjection(this.objectLoaderBuilder.build(loadingOptions), q -> new HibernateOrmSearchQuery(q, this.sessionImplementor, loadingOptions), projection);
    }

    @Override
    public <T> SearchQueryResultContext<? extends SearchQuery<T>> asProjection(Function<? super SearchProjectionFactoryContext<PojoReference, O>, ? extends SearchProjectionTerminalContext<T>> projectionContributor) {
        return this.asProjection(projectionContributor.apply(this.searchScopeDelegate.projection()).toProjection());
    }

    @Override
    public SearchQueryResultContext<? extends SearchQuery<List<?>>> asProjections(SearchProjection<?> ... projections) {
        MutableObjectLoadingOptions loadingOptions = new MutableObjectLoadingOptions();
        return this.searchScopeDelegate.queryAsProjections(this.objectLoaderBuilder.build(loadingOptions), q -> new HibernateOrmSearchQuery(q, this.sessionImplementor, loadingOptions), projections);
    }
}

