/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.CacheMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.mapper.orm.impl.HibernateSearchContextService;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.spi.HibernateOrmMapping;
import org.hibernate.search.mapper.orm.massindexing.MassIndexer;
import org.hibernate.search.mapper.orm.massindexing.impl.BatchCoordinator;
import org.hibernate.search.mapper.orm.massindexing.monitor.MassIndexingMonitor;
import org.hibernate.search.mapper.orm.massindexing.monitor.impl.SimpleIndexingProgressMonitor;
import org.hibernate.search.util.common.impl.Executors;
import org.hibernate.search.util.common.impl.StringHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class MassIndexerImpl
implements MassIndexer {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final HibernateOrmMapping mapping;
    private final SessionFactoryImplementor sessionFactory;
    private final String tenantIdentifier;
    protected final Set<Class<?>> rootEntities;
    private int typesToIndexInParallel = 1;
    private int documentBuilderThreads = 6;
    private int objectLoadingBatchSize = 10;
    private long objectsLimit = 0L;
    private CacheMode cacheMode = CacheMode.IGNORE;
    private boolean optimizeAtEnd = true;
    private boolean purgeAtStart = true;
    private boolean optimizeAfterPurge = true;
    private MassIndexingMonitor monitor;
    private int idFetchSize = 100;
    private Integer idLoadingTransactionTimeout;

    public MassIndexerImpl(SessionFactoryImplementor sessionFactory, String tenantIdentifier, Class<?> ... entities) {
        this.sessionFactory = sessionFactory;
        this.mapping = ((HibernateSearchContextService)sessionFactory.getServiceRegistry().getService(HibernateSearchContextService.class)).getMapping();
        this.tenantIdentifier = tenantIdentifier;
        this.rootEntities = MassIndexerImpl.toRootEntities(this.mapping, entities);
        this.monitor = new SimpleIndexingProgressMonitor();
    }

    private static Set<Class<?>> toRootEntities(HibernateOrmMapping mapping, Class<?> ... selection) {
        HashSet entities = new HashSet();
        HashSet nonIndexedEntities = new HashSet();
        for (Class<?> clazz : selection) {
            Set<Class<?>> indexedTypesPolymorphic = mapping.getIndexedTypesPolymorphic(clazz);
            if (indexedTypesPolymorphic.isEmpty()) {
                nonIndexedEntities.add(clazz);
                continue;
            }
            entities.addAll(indexedTypesPolymorphic);
        }
        for (Class clazz : nonIndexedEntities) {
            if (mapping.isWorkable(clazz)) continue;
            throw log.someTargetedEntityTypesNotConfigured(StringHelper.join(nonIndexedEntities, (String)","));
        }
        if (!nonIndexedEntities.isEmpty()) {
            throw log.someTargetedEntityTypesNotIndexed(StringHelper.join(nonIndexedEntities, (String)","));
        }
        HashSet cleaned = new HashSet();
        HashSet<Class> hashSet = new HashSet<Class>();
        for (Class clazz : entities) {
            boolean typeIsOk = true;
            for (Class clazz2 : cleaned) {
                if (clazz2.isAssignableFrom(clazz)) {
                    typeIsOk = false;
                    break;
                }
                if (!clazz.isAssignableFrom(clazz2)) continue;
                hashSet.add(clazz2);
            }
            if (!typeIsOk) continue;
            cleaned.add(clazz);
        }
        cleaned.removeAll(hashSet);
        log.debugf("Targets for indexing job: %s", cleaned);
        return cleaned;
    }

    @Override
    public MassIndexer typesToIndexInParallel(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be at least 1");
        }
        this.typesToIndexInParallel = Math.min(numberOfThreads, this.rootEntities.size());
        return this;
    }

    @Override
    public MassIndexer cacheMode(CacheMode cacheMode) {
        if (cacheMode == null) {
            throw new IllegalArgumentException("cacheMode must not be null");
        }
        this.cacheMode = cacheMode;
        return this;
    }

    @Override
    public MassIndexer threadsToLoadObjects(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be at least 1");
        }
        this.documentBuilderThreads = numberOfThreads;
        return this;
    }

    @Override
    public MassIndexer batchSizeToLoadObjects(int batchSize) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("batchSize must be at least 1");
        }
        this.objectLoadingBatchSize = batchSize;
        return this;
    }

    @Override
    public MassIndexer optimizeOnFinish(boolean optimize) {
        this.optimizeAtEnd = optimize;
        return this;
    }

    @Override
    public MassIndexer optimizeAfterPurge(boolean optimize) {
        this.optimizeAfterPurge = optimize;
        return this;
    }

    @Override
    public MassIndexer purgeAllOnStart(boolean purgeAll) {
        this.purgeAtStart = purgeAll;
        return this;
    }

    @Override
    public MassIndexer transactionTimeout(int timeoutInSeconds) {
        this.idLoadingTransactionTimeout = timeoutInSeconds;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<?> start() {
        BatchCoordinator coordinator = this.createCoordinator();
        ThreadPoolExecutor executor = Executors.newFixedThreadPool((int)1, (String)"batch coordinator");
        try {
            Future<?> future = executor.submit(coordinator);
            return future;
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    public void startAndWait() throws InterruptedException {
        BatchCoordinator coordinator = this.createCoordinator();
        coordinator.run();
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    protected BatchCoordinator createCoordinator() {
        return new BatchCoordinator(this.rootEntities, this.sessionFactory, this.mapping, this.typesToIndexInParallel, this.documentBuilderThreads, this.cacheMode, this.objectLoadingBatchSize, this.objectsLimit, this.optimizeAtEnd, this.purgeAtStart, this.optimizeAfterPurge, this.monitor, this.idFetchSize, this.idLoadingTransactionTimeout, this.tenantIdentifier);
    }

    @Override
    public MassIndexer limitIndexedObjectsTo(long maximum) {
        this.objectsLimit = maximum;
        return this;
    }

    @Override
    public MassIndexer idFetchSize(int idFetchSize) {
        this.idFetchSize = idFetchSize;
        return this;
    }
}

