/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.internal.StatelessSessionImpl;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.impl.ProducerConsumerQueue;
import org.hibernate.search.mapper.orm.massindexing.impl.StatelessSessionAwareRunnable;
import org.hibernate.search.mapper.orm.massindexing.monitor.MassIndexingMonitor;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class IdentifierProducer
implements StatelessSessionAwareRunnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ProducerConsumerQueue<List<Serializable>> destination;
    private final SessionFactory sessionFactory;
    private final int batchSize;
    private final Class<?> indexedType;
    private final MassIndexingMonitor monitor;
    private final long objectsLimit;
    private final int idFetchSize;
    private final String tenantId;

    public IdentifierProducer(ProducerConsumerQueue<List<Serializable>> fromIdentifierListToEntities, SessionFactory sessionFactory, int objectLoadingBatchSize, Class<?> indexedType, MassIndexingMonitor monitor, long objectsLimit, int idFetchSize, String tenantId) {
        this.destination = fromIdentifierListToEntities;
        this.sessionFactory = sessionFactory;
        this.batchSize = objectLoadingBatchSize;
        this.indexedType = indexedType;
        this.monitor = monitor;
        this.objectsLimit = objectsLimit;
        this.idFetchSize = idFetchSize;
        this.tenantId = tenantId;
        log.trace("created");
    }

    @Override
    public void run(StatelessSession upperSession) {
        log.trace("started");
        try {
            this.inTransactionWrapper((StatelessSessionImpl)upperSession);
        }
        catch (Exception exception) {
            String errorMessage = log.massIndexerExceptionWhileFetchingIds();
            throw new RuntimeException(errorMessage, exception);
        }
        finally {
            this.destination.producerStopping();
        }
        log.trace("finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inTransactionWrapper(StatelessSessionImpl upperSession) {
        StatelessSessionImpl session = upperSession;
        if (upperSession == null) {
            session = this.tenantId == null ? (StatelessSessionImpl)this.sessionFactory.openStatelessSession() : (StatelessSessionImpl)this.sessionFactory.withStatelessOptions().tenantIdentifier(this.tenantId).openStatelessSession();
        }
        try {
            boolean controlTransactions;
            Transaction transaction = session.accessTransaction();
            boolean bl = controlTransactions = !transaction.isActive();
            if (controlTransactions) {
                transaction.begin();
            }
            try {
                this.loadAllIdentifiers((StatelessSession)session);
            }
            finally {
                if (controlTransactions) {
                    transaction.commit();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (upperSession == null) {
                session.close();
            }
        }
    }

    private void loadAllIdentifiers(StatelessSession session) throws InterruptedException {
        Number countAsNumber = (Number)this.createCriteria(session).setProjection(Projections.rowCount()).setCacheable(false).uniqueResult();
        long totalCount = countAsNumber.longValue();
        if (this.objectsLimit != 0L && this.objectsLimit < totalCount) {
            totalCount = this.objectsLimit;
        }
        if (log.isDebugEnabled()) {
            log.debugf("going to fetch %d primary keys", totalCount);
        }
        this.monitor.addToTotalCount(totalCount);
        Criteria criteria = this.createCriteria(session).setProjection((Projection)Projections.id()).setCacheable(false).setFetchSize(this.idFetchSize);
        ArrayList<Serializable> destinationList = new ArrayList<Serializable>(this.batchSize);
        long counter = 0L;
        try (ScrollableResults results = criteria.scroll(ScrollMode.FORWARD_ONLY);){
            while (results.next()) {
                Serializable id = (Serializable)results.get(0);
                destinationList.add(id);
                if (destinationList.size() == this.batchSize) {
                    StatelessSessionImpl sessionImpl = (StatelessSessionImpl)session;
                    if (!sessionImpl.isTransactionInProgress()) {
                        throw log.transactionNotActiveWhileProducingIdsForBatchIndexing(this.indexedType);
                    }
                    this.enqueueList(destinationList);
                    destinationList = new ArrayList(this.batchSize);
                }
                if (++counter != totalCount) continue;
                break;
            }
        }
        this.enqueueList(destinationList);
    }

    private Criteria createCriteria(StatelessSession session) {
        return new CriteriaImpl(this.indexedType.getName(), (SharedSessionContractImplementor)session);
    }

    private void enqueueList(List<Serializable> idsList) throws InterruptedException {
        if (!idsList.isEmpty()) {
            this.destination.put(idsList);
            log.tracef("produced a list of ids %s", idsList);
        }
    }
}

