/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.CacheMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.spi.HibernateOrmMapping;
import org.hibernate.search.mapper.orm.massindexing.impl.BatchIndexingWorkspace;
import org.hibernate.search.mapper.orm.massindexing.impl.ErrorHandledRunnable;
import org.hibernate.search.mapper.orm.massindexing.monitor.MassIndexingMonitor;
import org.hibernate.search.mapper.pojo.work.spi.PojoMappingWorkExecutor;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Executors;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class BatchCoordinator
extends ErrorHandledRunnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Set<Class<?>> rootEntities;
    private final SessionFactoryImplementor sessionFactory;
    private final HibernateOrmMapping mapping;
    private final PojoMappingWorkExecutor mappingWorkExecutor;
    private final int typesToIndexInParallel;
    private final int documentBuilderThreads;
    private final CacheMode cacheMode;
    private final int objectLoadingBatchSize;
    private final boolean optimizeAtEnd;
    private final boolean purgeAtStart;
    private final boolean optimizeAfterPurge;
    private final CountDownLatch endAllSignal;
    private final MassIndexingMonitor monitor;
    private final long objectsLimit;
    private final int idFetchSize;
    private final Integer transactionTimeout;
    private final String tenantId;
    private final List<Future<?>> indexingTasks = new ArrayList();

    public BatchCoordinator(Set<Class<?>> rootEntities, SessionFactoryImplementor sessionFactory, HibernateOrmMapping mapping, int typesToIndexInParallel, int documentBuilderThreads, CacheMode cacheMode, int objectLoadingBatchSize, long objectsLimit, boolean optimizeAtEnd, boolean purgeAtStart, boolean optimizeAfterPurge, MassIndexingMonitor monitor, int idFetchSize, Integer transactionTimeout, String tenantId) {
        this.idFetchSize = idFetchSize;
        this.transactionTimeout = transactionTimeout;
        this.tenantId = tenantId;
        this.rootEntities = rootEntities;
        this.sessionFactory = sessionFactory;
        this.mapping = mapping;
        this.mappingWorkExecutor = mapping.createMappingWorkExecutor();
        this.typesToIndexInParallel = typesToIndexInParallel;
        this.documentBuilderThreads = documentBuilderThreads;
        this.cacheMode = cacheMode;
        this.objectLoadingBatchSize = objectLoadingBatchSize;
        this.optimizeAtEnd = optimizeAtEnd;
        this.purgeAtStart = purgeAtStart;
        this.optimizeAfterPurge = optimizeAfterPurge;
        this.monitor = monitor;
        this.objectsLimit = objectsLimit;
        this.endAllSignal = new CountDownLatch(rootEntities.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runWithErrorHandler() {
        if (!this.indexingTasks.isEmpty()) {
            throw new AssertionFailure("BatchCoordinator instance not expected to be reused - indexingTasks should be empty");
        }
        try {
            this.beforeBatch();
            this.doBatchWork();
            this.afterBatch();
        }
        catch (InterruptedException e) {
            log.interruptedBatchIndexing();
            for (Future<?> task : this.indexingTasks) {
                if (task.isDone()) continue;
                task.cancel(true);
            }
            this.afterBatchOnInterruption();
            Thread.currentThread().interrupt();
        }
        finally {
            this.monitor.indexingCompleted();
        }
    }

    private void doBatchWork() throws InterruptedException {
        ThreadPoolExecutor executor = Executors.newFixedThreadPool((int)this.typesToIndexInParallel, (String)"BatchIndexingWorkspace");
        for (Class<?> type : this.rootEntities) {
            this.indexingTasks.add(executor.submit(new BatchIndexingWorkspace(this.sessionFactory, this.mapping, type, this.documentBuilderThreads, this.cacheMode, this.objectLoadingBatchSize, this.endAllSignal, this.monitor, this.objectsLimit, this.idFetchSize, this.transactionTimeout, this.tenantId)));
        }
        executor.shutdown();
        this.endAllSignal.await();
    }

    private void afterBatch() {
        if (this.optimizeAtEnd) {
            this.mappingWorkExecutor.optimize(this.rootEntities).join();
        }
        this.mappingWorkExecutor.flush(this.rootEntities).join();
    }

    private void afterBatchOnInterruption() {
        this.mappingWorkExecutor.flush(this.rootEntities).join();
    }

    private void beforeBatch() {
        if (this.purgeAtStart) {
            this.mappingWorkExecutor.purge(this.rootEntities, this.tenantId).join();
            if (this.optimizeAfterPurge) {
                this.mappingWorkExecutor.optimize(this.rootEntities).join();
            }
        }
    }
}

