/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.engine.spi.SessionFactoryImplementor;

class HibernateSearchSessionFactoryObserver
implements SessionFactoryObserver {
    private final CompletableFuture<SessionFactoryImplementor> sessionFactoryCreatedFuture;
    private final CompletableFuture<?> sessionFactoryClosingFuture;

    HibernateSearchSessionFactoryObserver(CompletableFuture<SessionFactoryImplementor> sessionFactoryCreatedFuture, CompletableFuture<?> sessionFactoryClosingFuture) {
        this.sessionFactoryCreatedFuture = sessionFactoryCreatedFuture;
        this.sessionFactoryClosingFuture = sessionFactoryClosingFuture;
    }

    public synchronized void sessionFactoryCreated(SessionFactory factory) {
        SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)factory;
        this.sessionFactoryCreatedFuture.complete(sessionFactoryImplementor);
    }

    public synchronized void sessionFactoryClosing(SessionFactory factory) {
        this.sessionFactoryClosingFuture.complete(null);
    }
}

