/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.cfg.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConsumedPropertyTrackingConfigurationPropertySource;
import org.hibernate.search.mapper.orm.cfg.impl.ConsumedPropertyKeysReport;
import org.hibernate.search.mapper.orm.cfg.impl.HibernateOrmConfigurationServicePropertySource;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class HibernateOrmConfigurationPropertySource
implements ConfigurationPropertySource {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<Boolean> ENABLE_CONFIGURATION_PROPERTY_TRACKING = ConfigurationProperty.forKey((String)"enable_configuration_property_tracking").asBoolean().withDefault((Object)true).build();
    private final HibernateOrmConfigurationServicePropertySource configurationServiceSource;
    private final ConsumedPropertyTrackingConfigurationPropertySource consumedPropertyTrackingPropertySource;
    private final ConfigurationPropertySource delegate;

    public HibernateOrmConfigurationPropertySource(ConfigurationService configurationService) {
        this.configurationServiceSource = new HibernateOrmConfigurationServicePropertySource(configurationService);
        ConfigurationPropertySource maskedSource = this.configurationServiceSource.withMask("hibernate.search");
        if (((Boolean)ENABLE_CONFIGURATION_PROPERTY_TRACKING.get(maskedSource)).booleanValue()) {
            this.consumedPropertyTrackingPropertySource = new ConsumedPropertyTrackingConfigurationPropertySource(maskedSource);
            ENABLE_CONFIGURATION_PROPERTY_TRACKING.get((ConfigurationPropertySource)this.consumedPropertyTrackingPropertySource);
            this.delegate = this.consumedPropertyTrackingPropertySource;
        } else {
            this.consumedPropertyTrackingPropertySource = null;
            this.delegate = maskedSource;
        }
    }

    public Optional<?> get(String key) {
        return this.delegate.get(key);
    }

    public Optional<String> resolve(String key) {
        return this.delegate.resolve(key);
    }

    public Map<?, ?> getAllRawProperties() {
        return this.configurationServiceSource.getAllRawProperties();
    }

    public Optional<ConsumedPropertyKeysReport> getConsumedPropertiesReport() {
        if (this.consumedPropertyTrackingPropertySource == null) {
            return Optional.empty();
        }
        return Optional.of(new ConsumedPropertyKeysReport(this.configurationServiceSource.resolveAll("hibernate.search."), this.consumedPropertyTrackingPropertySource.getConsumedPropertyKeys()));
    }

    public void beforeBoot() {
        if (this.consumedPropertyTrackingPropertySource == null) {
            log.configurationPropertyTrackingDisabled();
        }
    }

    public void afterBoot(Optional<ConsumedPropertyKeysReport> previousReport) {
        List reports = CollectionHelper.asImmutableList((Object[])new Optional[]{previousReport, this.getConsumedPropertiesReport()});
        LinkedHashSet<String> unconsumedPropertyKeys = new LinkedHashSet<String>();
        for (Optional report : reports) {
            if (!report.isPresent()) continue;
            unconsumedPropertyKeys.addAll(((ConsumedPropertyKeysReport)report.get()).getAvailablePropertyKeys());
        }
        for (Optional report : reports) {
            if (!report.isPresent()) continue;
            unconsumedPropertyKeys.removeAll(((ConsumedPropertyKeysReport)report.get()).getConsumedPropertyKeys());
        }
        if (!unconsumedPropertyKeys.isEmpty()) {
            log.configurationPropertyTrackingUnusedProperties(unconsumedPropertyKeys, ENABLE_CONFIGURATION_PROPERTY_TRACKING.resolveOrRaw((ConfigurationPropertySource)this));
        }
    }
}

