/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import java.util.Collection;
import java.util.Collections;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.mapper.orm.mapping.context.impl.HibernateOrmMappingContextImpl;
import org.hibernate.search.mapper.orm.search.impl.HibernateOrmSearchTargetImpl;
import org.hibernate.search.mapper.orm.search.spi.HibernateOrmSearchTarget;
import org.hibernate.search.mapper.orm.session.context.impl.HibernateOrmSessionContextImpl;
import org.hibernate.search.mapper.orm.session.spi.HibernateOrmSearchManager;
import org.hibernate.search.mapper.orm.session.spi.HibernateOrmSearchManagerBuilder;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.search.spi.PojoSearchTargetDelegate;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.mapper.pojo.session.spi.AbstractPojoSearchManager;
import org.hibernate.search.mapper.pojo.work.spi.PojoSessionWorkExecutor;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkPlan;

public class HibernateOrmSearchManagerImpl
extends AbstractPojoSearchManager
implements HibernateOrmSearchManager {
    private final SessionImplementor sessionImplementor;

    private HibernateOrmSearchManagerImpl(HibernateOrmSearchManagerBuilderImpl builder) {
        super((AbstractPojoSearchManager.AbstractBuilder)builder);
        this.sessionImplementor = builder.sessionImplementor;
    }

    @Override
    public void close() {
    }

    @Override
    public <T> HibernateOrmSearchTarget<T> search(Class<T> targetedType) {
        return this.search(Collections.singleton(targetedType));
    }

    @Override
    public <T> HibernateOrmSearchTarget<T> search(Collection<? extends Class<? extends T>> targetedTypes) {
        PojoSearchTargetDelegate searchTargetDelegate = this.getDelegate().createPojoSearchTarget(targetedTypes);
        return new HibernateOrmSearchTargetImpl(searchTargetDelegate, this.sessionImplementor);
    }

    @Override
    public PojoWorkPlan createWorkPlan() {
        return this.getDelegate().createWorkPlan();
    }

    @Override
    public PojoSessionWorkExecutor createSessionWorkExecutor() {
        return this.getDelegate().createSessionWorkExecutor();
    }

    public static class HibernateOrmSearchManagerBuilderImpl
    extends AbstractPojoSearchManager.AbstractBuilder<HibernateOrmSearchManagerImpl>
    implements HibernateOrmSearchManagerBuilder {
        private final HibernateOrmMappingContextImpl mappingContext;
        private final SessionImplementor sessionImplementor;

        public HibernateOrmSearchManagerBuilderImpl(PojoMappingDelegate mappingDelegate, HibernateOrmMappingContextImpl mappingContext, SessionImplementor sessionImplementor) {
            super(mappingDelegate);
            this.mappingContext = mappingContext;
            this.sessionImplementor = sessionImplementor;
        }

        protected AbstractPojoSessionContextImplementor buildSessionContext() {
            return new HibernateOrmSessionContextImpl(this.mappingContext, this.sessionImplementor);
        }

        @Override
        public HibernateOrmSearchManagerImpl build() {
            return new HibernateOrmSearchManagerImpl(this);
        }
    }
}

