/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.util.HashMap;
import java.util.Set;
import java.util.function.Function;
import org.hibernate.Session;
import org.hibernate.search.engine.search.loading.spi.ObjectLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmByTypeObjectLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmComposableObjectLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmSingleTypeByIdObjectLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableObjectLoadingOptions;
import org.hibernate.search.mapper.pojo.search.PojoReference;

public class ObjectLoaderBuilder<O> {
    private final Session session;
    private final Set<Class<? extends O>> concreteIndexedClasses;

    public ObjectLoaderBuilder(Session session, Set<Class<? extends O>> concreteIndexedClasses) {
        this.session = session;
        this.concreteIndexedClasses = concreteIndexedClasses;
    }

    public ObjectLoader<PojoReference, O> build(MutableObjectLoadingOptions mutableLoadingOptions) {
        return this.build(mutableLoadingOptions, Function.identity());
    }

    public <T> ObjectLoader<PojoReference, T> build(MutableObjectLoadingOptions mutableLoadingOptions, Function<O, T> hitTransformer) {
        if (this.concreteIndexedClasses.size() == 1) {
            Class<? extends O> concreteIndexedType = this.concreteIndexedClasses.iterator().next();
            return this.buildForSingleType(mutableLoadingOptions, concreteIndexedType, hitTransformer);
        }
        return this.buildForMultipleTypes(mutableLoadingOptions, hitTransformer);
    }

    private <T> HibernateOrmComposableObjectLoader<PojoReference, T> buildForSingleType(MutableObjectLoadingOptions mutableLoadingOptions, Class<? extends O> concreteIndexedType, Function<? super O, T> hitTransformer) {
        return new HibernateOrmSingleTypeByIdObjectLoader<O, T>(this.session, concreteIndexedType, mutableLoadingOptions, hitTransformer);
    }

    private <T> ObjectLoader<PojoReference, T> buildForMultipleTypes(MutableObjectLoadingOptions mutableLoadingOptions, Function<? super O, T> hitTransformer) {
        HashMap delegateByConcreteType = new HashMap(this.concreteIndexedClasses.size());
        for (Class<? extends O> clazz : this.concreteIndexedClasses) {
            HibernateOrmComposableObjectLoader<PojoReference, T> delegate = this.buildForSingleType(mutableLoadingOptions, clazz, hitTransformer);
            delegateByConcreteType.put(clazz, delegate);
        }
        return new HibernateOrmByTypeObjectLoader(delegateByConcreteType);
    }
}

