/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;
import javax.persistence.metamodel.ManagedType;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmGenericContextHelper;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmRawTypeModel;
import org.hibernate.search.mapper.orm.util.impl.HibernateOrmXClassOrdering;
import org.hibernate.search.mapper.pojo.model.spi.GenericContextAwarePojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.MemberPropertyHandle;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.mapper.pojo.util.spi.AnnotationHelper;
import org.hibernate.search.util.impl.common.ReflectionHelper;
import org.hibernate.search.util.impl.common.StreamHelper;

public class HibernateOrmBootstrapIntrospector
implements PojoBootstrapIntrospector {
    private final ReflectionManager reflectionManager;
    private final MethodHandles.Lookup lookup;
    private final AnnotationHelper annotationHelper;
    private final SessionFactoryImplementor sessionFactoryImplementor;
    private final HibernateOrmGenericContextHelper genericContextHelper;
    private final GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<?> missingRawTypeDeclaringContext;
    private final Map<Class<?>, PojoRawTypeModel<?>> typeModelCache = new HashMap();

    public HibernateOrmBootstrapIntrospector(Metadata metadata, SessionFactoryImplementor sessionFactoryImplementor) {
        ReflectionManager metadataReflectionManager = null;
        if (metadata instanceof MetadataImplementor) {
            metadataReflectionManager = ((MetadataImplementor)metadata).getMetadataBuildingOptions().getReflectionManager();
        }
        this.reflectionManager = metadataReflectionManager != null ? metadataReflectionManager : new JavaReflectionManager();
        this.lookup = MethodHandles.publicLookup();
        this.annotationHelper = new AnnotationHelper(this.lookup);
        this.sessionFactoryImplementor = sessionFactoryImplementor;
        this.genericContextHelper = new HibernateOrmGenericContextHelper(this);
        this.missingRawTypeDeclaringContext = new GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext((GenericContextAwarePojoGenericTypeModel.Helper)this.genericContextHelper, Object.class);
    }

    public <T> PojoRawTypeModel<T> getTypeModel(Class<T> clazz) {
        if (clazz.isPrimitive()) {
            clazz = ReflectionHelper.getPrimitiveWrapperType(clazz);
        }
        return this.typeModelCache.computeIfAbsent(clazz, this::createTypeModel);
    }

    public <T> PojoGenericTypeModel<T> getGenericTypeModel(Class<T> clazz) {
        return this.missingRawTypeDeclaringContext.createGenericTypeModel(clazz);
    }

    <T> Stream<HibernateOrmRawTypeModel<? super T>> getAscendingSuperTypes(XClass xClass) {
        return HibernateOrmXClassOrdering.get().getAscendingSuperTypes(xClass).map(superType -> (HibernateOrmRawTypeModel)this.getTypeModel((XClass)superType));
    }

    <T> Stream<HibernateOrmRawTypeModel<? super T>> getDescendingSuperTypes(XClass xClass) {
        return HibernateOrmXClassOrdering.get().getDescendingSuperTypes(xClass).map(superType -> (HibernateOrmRawTypeModel)this.getTypeModel((XClass)superType));
    }

    XClass toXClass(Class<?> type) {
        return this.reflectionManager.toXClass(type);
    }

    Map<String, XProperty> getDeclaredFieldAccessXPropertiesByName(XClass xClass) {
        return xClass.getDeclaredProperties("field").stream().collect(this.xPropertiesByNameNoDuplicate());
    }

    Map<String, XProperty> getDeclaredMethodAccessXPropertiesByName(XClass xClass) {
        return xClass.getDeclaredProperties("property").stream().collect(this.xPropertiesByNameNoDuplicate());
    }

    <A extends Annotation> Optional<A> getAnnotationByType(XAnnotatedElement xAnnotated, Class<A> annotationType) {
        return Optional.ofNullable(xAnnotated.getAnnotation(annotationType));
    }

    <A extends Annotation> Stream<A> getAnnotationsByType(XAnnotatedElement xAnnotated, Class<A> annotationType) {
        return Arrays.stream(xAnnotated.getAnnotations()).flatMap(arg_0 -> ((AnnotationHelper)this.annotationHelper).expandRepeatableContainingAnnotation(arg_0)).filter(annotation -> annotationType.isAssignableFrom(annotation.annotationType())).map(annotationType::cast);
    }

    Stream<? extends Annotation> getAnnotationsByMetaAnnotationType(XAnnotatedElement xAnnotated, Class<? extends Annotation> metaAnnotationType) {
        return Arrays.stream(xAnnotated.getAnnotations()).flatMap(arg_0 -> ((AnnotationHelper)this.annotationHelper).expandRepeatableContainingAnnotation(arg_0)).filter(annotation -> this.annotationHelper.isMetaAnnotated(annotation, metaAnnotationType));
    }

    MemberPropertyHandle createPropertyHandle(String name, Member member) throws IllegalAccessException {
        if (member instanceof Method) {
            Method method = (Method)member;
            HibernateOrmBootstrapIntrospector.setAccessible(method);
            return new MemberPropertyHandle(name, (Member)method, this.lookup.unreflect(method));
        }
        if (member instanceof Field) {
            Field field = (Field)member;
            HibernateOrmBootstrapIntrospector.setAccessible(field);
            return new MemberPropertyHandle(name, (Member)field, this.lookup.unreflectGetter(field));
        }
        throw new AssertionFailure("Unexpected type for a " + Member.class.getName() + ": " + member);
    }

    private PojoTypeModel<?> getTypeModel(XClass xClass) {
        return this.getTypeModel(this.reflectionManager.toClass(xClass));
    }

    private <T> PojoRawTypeModel<T> createTypeModel(Class<T> type) {
        ManagedType<T> managedType = this.getManagedType(type);
        return new HibernateOrmRawTypeModel<T>(this, type, managedType, new GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext((GenericContextAwarePojoGenericTypeModel.Helper)this.genericContextHelper, type));
    }

    private <T> ManagedType<T> getManagedType(Class<T> type) {
        try {
            return this.sessionFactoryImplementor.getMetamodel().managedType(type);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    private Collector<XProperty, ?, Map<String, XProperty>> xPropertiesByNameNoDuplicate() {
        return StreamHelper.toMap(XMember::getName, Function.identity(), TreeMap::new);
    }

    private static void setAccessible(AccessibleObject member) {
        block2: {
            try {
                member.setAccessible(true);
            }
            catch (SecurityException se) {
                if (Modifier.isPublic(((Member)((Object)member)).getModifiers())) break block2;
                throw se;
            }
        }
    }
}

