/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.lang.invoke.MethodHandles;
import javax.transaction.SystemException;
import org.hibernate.StatelessSession;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.impl.BatchTransactionalContext;
import org.hibernate.search.mapper.orm.massindexing.impl.ErrorHandledRunnable;
import org.hibernate.search.mapper.orm.massindexing.impl.StatelessSessionAwareRunnable;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class OptionallyWrapInJTATransaction
extends ErrorHandledRunnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final StatelessSessionAwareRunnable statelessSessionAwareRunnable;
    private final BatchTransactionalContext batchContext;
    private final Integer transactionTimeout;
    private final boolean wrapInTransaction;
    private final String tenantId;

    public OptionallyWrapInJTATransaction(BatchTransactionalContext batchContext, StatelessSessionAwareRunnable statelessSessionAwareRunnable, Integer transactionTimeout, String tenantId) {
        this.batchContext = batchContext;
        this.transactionTimeout = transactionTimeout;
        this.tenantId = tenantId;
        this.statelessSessionAwareRunnable = statelessSessionAwareRunnable;
        this.wrapInTransaction = batchContext.wrapInTransaction();
    }

    @Override
    public void runWithErrorHandler() throws Exception {
        if (this.wrapInTransaction) {
            try (StatelessSession statelessSession = this.batchContext.factory.withStatelessOptions().tenantIdentifier(this.tenantId).openStatelessSession();){
                if (this.transactionTimeout != null) {
                    this.batchContext.transactionManager.setTransactionTimeout(this.transactionTimeout.intValue());
                }
                this.batchContext.transactionManager.begin();
                this.statelessSessionAwareRunnable.run(statelessSession);
                this.batchContext.transactionManager.commit();
            }
        } else {
            this.statelessSessionAwareRunnable.run(null);
        }
    }

    @Override
    protected void cleanUpOnError() {
        if (this.wrapInTransaction) {
            try {
                this.batchContext.transactionManager.rollback();
            }
            catch (SystemException e) {
                log.errorRollingBackTransaction(e.getMessage(), (Exception)((Object)e));
            }
        }
    }
}

