/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.CacheMode;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.spi.HibernateOrmMapping;
import org.hibernate.search.mapper.orm.massindexing.impl.BatchTransactionalContext;
import org.hibernate.search.mapper.orm.massindexing.impl.ErrorHandledRunnable;
import org.hibernate.search.mapper.orm.massindexing.impl.IdentifierConsumerDocumentProducer;
import org.hibernate.search.mapper.orm.massindexing.impl.IdentifierProducer;
import org.hibernate.search.mapper.orm.massindexing.impl.OptionallyWrapInJTATransaction;
import org.hibernate.search.mapper.orm.massindexing.impl.ProducerConsumerQueue;
import org.hibernate.search.mapper.orm.massindexing.monitor.MassIndexingMonitor;
import org.hibernate.search.util.AssertionFailure;
import org.hibernate.search.util.impl.common.Executors;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class BatchIndexingWorkspace
extends ErrorHandledRunnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final SessionFactoryImplementor sessionFactory;
    private final ProducerConsumerQueue<List<Serializable>> primaryKeyStream;
    private final int documentBuilderThreads;
    private final Class<?> indexedType;
    private final String idNameOfIndexedType;
    private final CountDownLatch producerEndSignal;
    private final CountDownLatch endAllSignal;
    private final MassIndexingMonitor monitor;
    private final CacheMode cacheMode;
    private final int objectLoadingBatchSize;
    private final long objectsLimit;
    private final int idFetchSize;
    private final Integer transactionTimeout;
    private final String tenantId;
    private final HibernateOrmMapping mapping;
    private final List<Future<?>> tasks = new ArrayList();

    public BatchIndexingWorkspace(SessionFactoryImplementor sessionFactory, HibernateOrmMapping mapping, Class<?> type, int objectLoadingThreads, CacheMode cacheMode, int objectLoadingBatchSize, CountDownLatch endAllSignal, MassIndexingMonitor monitor, long objectsLimit, int idFetchSize, Integer transactionTimeout, String tenantId) {
        this.indexedType = type;
        this.idFetchSize = idFetchSize;
        this.transactionTimeout = transactionTimeout;
        this.tenantId = tenantId;
        this.mapping = mapping;
        this.idNameOfIndexedType = sessionFactory.getMetamodel().entity(this.indexedType).getId(Object.class).getName();
        this.sessionFactory = sessionFactory;
        this.documentBuilderThreads = objectLoadingThreads;
        this.cacheMode = cacheMode;
        this.objectLoadingBatchSize = objectLoadingBatchSize;
        this.primaryKeyStream = new ProducerConsumerQueue(1);
        this.endAllSignal = endAllSignal;
        this.producerEndSignal = new CountDownLatch(this.documentBuilderThreads);
        this.monitor = monitor;
        this.objectsLimit = objectsLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runWithErrorHandler() {
        if (this.tasks.size() > 0) {
            throw new AssertionFailure("BatchIndexingWorkspace instance not expected to be reused - tasks should be empty");
        }
        try {
            BatchTransactionalContext transactionalContext = new BatchTransactionalContext(this.sessionFactory);
            this.startTransformationToLuceneWork();
            this.startProducingPrimaryKeys(transactionalContext);
            try {
                this.producerEndSignal.await();
                log.debugf("All work for type %s has been produced", this.indexedType.getName());
            }
            catch (InterruptedException e) {
                for (Future<?> task : this.tasks) {
                    if (task.isDone()) continue;
                    task.cancel(true);
                }
                Thread.currentThread().interrupt();
                throw log.interruptedBatchIndexingException(e);
            }
        }
        finally {
            this.endAllSignal.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProducingPrimaryKeys(BatchTransactionalContext transactionalContext) {
        OptionallyWrapInJTATransaction primaryKeyOutputter = new OptionallyWrapInJTATransaction(transactionalContext, new IdentifierProducer(this.primaryKeyStream, (SessionFactory)this.sessionFactory, this.objectLoadingBatchSize, this.indexedType, this.monitor, this.objectsLimit, this.idFetchSize, this.tenantId), this.transactionTimeout, this.tenantId);
        ThreadPoolExecutor execIdentifiersLoader = Executors.newFixedThreadPool((int)1, (String)"identifierloader");
        try {
            this.tasks.add(execIdentifiersLoader.submit(primaryKeyOutputter));
        }
        finally {
            execIdentifiersLoader.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTransformationToLuceneWork() {
        IdentifierConsumerDocumentProducer documentOutputter = new IdentifierConsumerDocumentProducer(this.primaryKeyStream, this.monitor, (SessionFactory)this.sessionFactory, this.producerEndSignal, this.cacheMode, this.indexedType, this.idNameOfIndexedType, this.transactionTimeout, this.tenantId, this.mapping);
        ThreadPoolExecutor execFirstLoader = Executors.newFixedThreadPool((int)this.documentBuilderThreads, (String)"entityloader");
        try {
            for (int i = 0; i < this.documentBuilderThreads; ++i) {
                this.tasks.add(execFirstLoader.submit(documentOutputter));
            }
        }
        finally {
            execFirstLoader.shutdown();
        }
    }
}

