/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import javax.persistence.EntityManager;
import org.hibernate.Hibernate;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.context.impl.HibernateOrmMappingContextImpl;
import org.hibernate.search.mapper.orm.mapping.spi.HibernateOrmMapping;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchManagerImpl;
import org.hibernate.search.mapper.orm.session.spi.HibernateOrmSearchManager;
import org.hibernate.search.mapper.orm.session.spi.HibernateOrmSearchManagerBuilder;
import org.hibernate.search.mapper.pojo.mapping.spi.AbstractPojoMappingImplementor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.work.spi.PojoMappingWorkExecutor;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class HibernateOrmMappingImpl
extends AbstractPojoMappingImplementor<HibernateOrmMapping>
implements HibernateOrmMapping {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final HibernateOrmMappingContextImpl mappingContext;

    HibernateOrmMappingImpl(PojoMappingDelegate mappingDelegate, SessionFactoryImplementor sessionFactoryImplementor) {
        super(mappingDelegate);
        this.mappingContext = new HibernateOrmMappingContextImpl(sessionFactoryImplementor);
    }

    public HibernateOrmMapping toAPI() {
        return this;
    }

    @Override
    public HibernateOrmSearchManager createSearchManager(EntityManager entityManager) {
        return this.createSearchManagerBuilder(entityManager).build();
    }

    @Override
    public HibernateOrmSearchManagerBuilder createSearchManagerWithOptions(EntityManager entityManager) {
        return this.createSearchManagerBuilder(entityManager);
    }

    @Override
    public boolean isWorkable(Class<?> type) {
        return this.getDelegate().isWorkable(type);
    }

    @Override
    public boolean isIndexable(Class<?> type) {
        return this.getDelegate().isIndexable(type);
    }

    @Override
    public boolean isSearchable(Class<?> type) {
        return this.getDelegate().isSearchable(type);
    }

    @Override
    public boolean isWorkable(Object entity) {
        return this.isWorkable(Hibernate.getClass((Object)entity));
    }

    @Override
    public <E> Set<Class<? extends E>> getIndexedTypesPolymorphic(Class<E> entityType) {
        return this.getDelegate().getIndexedTypesPolymorphic(entityType);
    }

    @Override
    public PojoMappingWorkExecutor createMappingWorkExecutor() {
        return this.getDelegate().createMappingWorkExecutor();
    }

    private HibernateOrmSearchManagerBuilder createSearchManagerBuilder(EntityManager entityManager) {
        SessionImplementor sessionImplementor = (SessionImplementor)entityManager.unwrap(SessionImplementor.class);
        SessionFactory expectedSessionFactory = this.mappingContext.getSessionFactory();
        SessionFactoryImplementor givenSessionFactory = sessionImplementor.getSessionFactory();
        if (!givenSessionFactory.equals(expectedSessionFactory)) {
            throw log.usingDifferentSessionFactories(expectedSessionFactory, (SessionFactory)givenSessionFactory);
        }
        return new HibernateOrmSearchManagerImpl.HibernateOrmSearchManagerBuilderImpl(this.getDelegate(), this.mappingContext, sessionImplementor);
    }
}

