/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.transaction.Synchronization;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkPlan;
import org.hibernate.search.util.impl.common.LoggerFactory;

class InTransactionWorkQueueSynchronization
implements Synchronization {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoWorkPlan workPlan;
    private final Map<?, ?> workPlanPerTransaction;
    private final Object transactionIdentifier;

    InTransactionWorkQueueSynchronization(PojoWorkPlan workPlan, Map<?, ?> workPlanPerTransaction, Object transactionIdentifier) {
        this.workPlan = workPlan;
        this.workPlanPerTransaction = workPlanPerTransaction;
        this.transactionIdentifier = transactionIdentifier;
    }

    public void beforeCompletion() {
        try {
            log.tracef("Processing Transaction's beforeCompletion() phase for %s. Performing work.", this);
            CompletableFuture future = this.workPlan.execute();
            future.join();
        }
        finally {
            this.workPlanPerTransaction.remove(this.transactionIdentifier);
        }
    }

    public void afterCompletion(int status) {
    }
}

