/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.impl;

import java.util.Collection;
import org.hibernate.engine.spi.SessionDelegatorBaseImpl;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.mapper.orm.hibernate.FullTextSearchTarget;
import org.hibernate.search.mapper.orm.hibernate.FullTextSession;
import org.hibernate.search.mapper.orm.impl.FullTextSearchTargetImpl;
import org.hibernate.search.mapper.orm.impl.HibernateSearchContextService;
import org.hibernate.search.mapper.orm.jpa.FullTextEntityManager;
import org.hibernate.search.mapper.orm.massindexing.MassIndexer;
import org.hibernate.search.mapper.orm.massindexing.impl.MassIndexerImpl;
import org.hibernate.search.mapper.orm.session.spi.HibernateOrmSearchManager;

public class FullTextSessionImpl
extends SessionDelegatorBaseImpl
implements FullTextSession {
    private transient HibernateOrmSearchManager searchManager = null;

    public FullTextSessionImpl(SessionImplementor delegate) {
        super(delegate);
    }

    public <T> T unwrap(Class<T> type) {
        if (type.equals(FullTextEntityManager.class)) {
            return (T)this;
        }
        if (type.equals(FullTextSession.class)) {
            return (T)this;
        }
        return (T)super.unwrap(type);
    }

    @Override
    public final <T> FullTextSearchTarget<T> search(Class<T> type) {
        return new FullTextSearchTargetImpl<T>(this.getSearchManager().search(type));
    }

    @Override
    public final <T> FullTextSearchTarget<T> search(Collection<? extends Class<? extends T>> types) {
        return new FullTextSearchTargetImpl(this.getSearchManager().search(types));
    }

    @Override
    public MassIndexer createIndexer(Class<?> ... types) {
        if (types.length == 0) {
            types = new Class[]{Object.class};
        }
        return new MassIndexerImpl(this.getFactory(), this.getTenantIdentifier(), types);
    }

    private HibernateOrmSearchManager getSearchManager() {
        if (this.searchManager == null) {
            HibernateSearchContextService contextService = (HibernateSearchContextService)this.delegate.getSessionFactory().getServiceRegistry().getService(HibernateSearchContextService.class);
            this.searchManager = contextService.getSearchManager(this.delegate);
        }
        return this.searchManager;
    }
}

