/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.common.spi.SearchIntegrationBuilder;
import org.hibernate.search.engine.environment.bean.spi.BeanResolver;
import org.hibernate.search.engine.environment.bean.spi.ReflectionBeanResolver;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.ResourceResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingInitiator;
import org.hibernate.search.engine.mapper.mapping.spi.MappingKey;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateOrmBeanContainerBeanResolver;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateOrmClassLoaderServiceClassAndResourceResolver;
import org.hibernate.search.mapper.orm.cfg.impl.HibernateOrmConfigurationPropertySource;
import org.hibernate.search.mapper.orm.event.impl.FullTextIndexEventListener;
import org.hibernate.search.mapper.orm.impl.HibernateSearchContextService;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMappingInitiator;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMappingKey;
import org.hibernate.search.mapper.orm.mapping.spi.HibernateOrmMapping;
import org.hibernate.search.mapper.orm.spi.EnvironmentSynchronizer;
import org.hibernate.search.util.impl.common.Closer;
import org.hibernate.search.util.impl.common.Contracts;
import org.hibernate.search.util.impl.common.SuppressingCloser;

public class HibernateSearchSessionFactoryObserver
implements SessionFactoryObserver {
    private final HibernateOrmConfigurationPropertySource propertySource;
    private final JndiService namingService;
    private final ClassLoaderService hibernateOrmClassLoaderService;
    private final EnvironmentSynchronizer environmentSynchronizer;
    private final ManagedBeanRegistry managedBeanRegistry;
    private final FullTextIndexEventListener listener;
    private final Metadata metadata;
    private final CompletableFuture<HibernateSearchContextService> contextFuture = new CompletableFuture();
    private final CompletableFuture<?> closingTrigger = new CompletableFuture();

    HibernateSearchSessionFactoryObserver(Metadata metadata, HibernateOrmConfigurationPropertySource propertySource, FullTextIndexEventListener listener, ClassLoaderService hibernateOrmClassLoaderService, EnvironmentSynchronizer environmentSynchronizer, ManagedBeanRegistry managedBeanRegistry, JndiService namingService) {
        this.metadata = metadata;
        this.propertySource = propertySource;
        this.listener = listener;
        Contracts.assertNotNull((Object)hibernateOrmClassLoaderService, (String)"Hibernate ORM ClassResolver");
        this.hibernateOrmClassLoaderService = hibernateOrmClassLoaderService;
        this.environmentSynchronizer = environmentSynchronizer;
        this.managedBeanRegistry = managedBeanRegistry;
        this.namingService = namingService;
        this.contextFuture.thenAcceptBoth(this.closingTrigger, (context, ignored) -> this.cleanup((HibernateSearchContextService)context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionFactoryCreated(SessionFactory factory) {
        boolean failedBootScheduling = true;
        try {
            SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)factory;
            this.listener.initialize(this.contextFuture);
            if (this.environmentSynchronizer != null) {
                this.environmentSynchronizer.whenEnvironmentDestroying(() -> this.closingTrigger.complete(null));
                this.environmentSynchronizer.whenEnvironmentReady(() -> this.boot(sessionFactoryImplementor));
            } else {
                this.boot(sessionFactoryImplementor);
            }
            failedBootScheduling = false;
        }
        finally {
            if (failedBootScheduling) {
                this.cancelBoot();
            }
        }
    }

    private synchronized void boot(SessionFactoryImplementor sessionFactoryImplementor) {
        if (this.contextFuture.isDone()) {
            return;
        }
        ReflectionBeanResolver reflectionBeanResolver = null;
        Object beanResolver = null;
        try {
            BeanContainer beanContainer;
            SearchIntegrationBuilder builder = SearchIntegration.builder((ConfigurationPropertySource)this.propertySource);
            HibernateOrmMappingKey mappingKey = new HibernateOrmMappingKey();
            HibernateOrmMappingInitiator mappingInitiator = HibernateOrmMappingInitiator.create(this.metadata, sessionFactoryImplementor);
            builder.addMappingInitiator((MappingKey)mappingKey, (MappingInitiator)mappingInitiator);
            HibernateOrmClassLoaderServiceClassAndResourceResolver classAndResourceResolver = new HibernateOrmClassLoaderServiceClassAndResourceResolver(this.hibernateOrmClassLoaderService);
            builder.setClassResolver((ClassResolver)classAndResourceResolver);
            builder.setResourceResolver((ResourceResolver)classAndResourceResolver);
            reflectionBeanResolver = new ReflectionBeanResolver((ClassResolver)classAndResourceResolver);
            if (this.managedBeanRegistry != null && (beanContainer = this.managedBeanRegistry.getBeanContainer()) != null) {
                beanResolver = new HibernateOrmBeanContainerBeanResolver(beanContainer, reflectionBeanResolver);
            }
            if (beanResolver == null) {
                beanResolver = reflectionBeanResolver;
            }
            builder.setBeanResolver((BeanResolver)beanResolver);
            SearchIntegration integration = builder.build();
            HibernateOrmMapping mapping = (HibernateOrmMapping)integration.getMapping((MappingKey)mappingKey);
            HibernateSearchContextService contextService = (HibernateSearchContextService)sessionFactoryImplementor.getServiceRegistry().getService(HibernateSearchContextService.class);
            contextService.initialize(integration, mapping);
            this.contextFuture.complete(contextService);
            this.propertySource.afterBootstrap();
        }
        catch (RuntimeException e) {
            ((SuppressingCloser)new SuppressingCloser((Throwable)e).push(BeanResolver::close, reflectionBeanResolver)).push(BeanResolver::close, beanResolver);
            this.contextFuture.completeExceptionally(e);
            throw e;
        }
    }

    public synchronized void sessionFactoryClosing(SessionFactory factory) {
        this.cancelBoot();
    }

    private synchronized void cancelBoot() {
        this.contextFuture.cancel(false);
    }

    public void sessionFactoryClosed(SessionFactory factory) {
        this.closingTrigger.complete(null);
    }

    private synchronized void cleanup(HibernateSearchContextService context) {
        try (Closer closer = new Closer();){
            closer.push(c -> c.getIntegration().close(), (Object)context);
        }
    }
}

