/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.container.spi.ContainedBean;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.spi.BeanResolver;
import org.hibernate.search.engine.environment.bean.spi.ReflectionBeanResolver;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateOrmContainedBeanBeanHolderAdapter;
import org.hibernate.search.util.impl.common.Contracts;

final class HibernateOrmBeanContainerBeanResolver
implements BeanResolver {
    private static final BeanContainer.LifecycleOptions LIFECYCLE_OPTIONS = new BeanContainer.LifecycleOptions(){

        public boolean canUseCachedReferences() {
            return false;
        }

        public boolean useJpaCompliantCreation() {
            return false;
        }
    };
    private final BeanContainer beanContainer;
    private final ReflectionBeanResolver fallback;
    private final BeanInstanceProducer fallbackInstanceProducer;

    HibernateOrmBeanContainerBeanResolver(BeanContainer beanContainer, final ReflectionBeanResolver fallback) {
        Contracts.assertNotNull((Object)beanContainer, (String)"beanContainer");
        this.beanContainer = beanContainer;
        this.fallback = fallback;
        this.fallbackInstanceProducer = new BeanInstanceProducer(){
            private final ReflectionBeanResolver delegate;
            {
                this.delegate = fallback;
            }

            public <B> B produceBeanInstance(Class<B> aClass) {
                return (B)this.delegate.resolveNoClosingNecessary(aClass);
            }

            public <B> B produceBeanInstance(String s, Class<B> aClass) {
                return (B)this.delegate.resolveNoClosingNecessary(aClass, s);
            }
        };
    }

    public void close() {
        this.fallback.close();
    }

    public <T> BeanHolder<T> resolve(Class<T> typeReference) {
        ContainedBean containedBean = this.beanContainer.getBean(typeReference, LIFECYCLE_OPTIONS, this.fallbackInstanceProducer);
        return new HibernateOrmContainedBeanBeanHolderAdapter(containedBean);
    }

    public <T> BeanHolder<T> resolve(Class<T> typeReference, String nameReference) {
        ContainedBean containedBean = this.beanContainer.getBean(nameReference, typeReference, LIFECYCLE_OPTIONS, this.fallbackInstanceProducer);
        return new HibernateOrmContainedBeanBeanHolderAdapter(containedBean);
    }
}

