/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm;

import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.mapper.orm.hibernate.FullTextSession;
import org.hibernate.search.mapper.orm.impl.FullTextSessionImpl;
import org.hibernate.search.mapper.orm.jpa.FullTextEntityManager;

public final class Search {
    private Search() {
    }

    public static FullTextSession getFullTextSession(Session session) {
        if (session instanceof FullTextSession) {
            return (FullTextSession)session;
        }
        return Search.createFullTextSession((SessionImplementor)session.unwrap(SessionImplementor.class));
    }

    public static FullTextEntityManager getFullTextEntityManager(EntityManager entityManager) {
        if (entityManager instanceof FullTextEntityManager) {
            return (FullTextEntityManager)entityManager;
        }
        return Search.createFullTextSession((SessionImplementor)entityManager.unwrap(SessionImplementor.class));
    }

    private static FullTextSession createFullTextSession(SessionImplementor sessionImplementor) {
        return new FullTextSessionImpl(sessionImplementor);
    }
}

