/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.mapping.impl;

import jakarta.persistence.AccessType;
import jakarta.persistence.EnumType;
import jakarta.persistence.Index;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import org.hibernate.annotations.UuidGenerator;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.internal.AccessJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.ColumnJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.EntityJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.EnumeratedJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.IndexJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.JdbcTypeCodeAnnotation;
import org.hibernate.boot.models.annotations.internal.TableJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.UuidGeneratorAnnotation;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.models.internal.MutableClassDetailsRegistry;
import org.hibernate.models.internal.jdk.JdkBuilders;
import org.hibernate.models.internal.jdk.JdkClassDetails;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class AdditionalMappingBuilder {
    private final MetadataBuildingContext buildingContext;
    private final Class<?> type;
    private final String name;
    private final List<BiConsumer<ModelsContext, MutableClassDetails>> contributors = new ArrayList<BiConsumer<ModelsContext, MutableClassDetails>>();

    public AdditionalMappingBuilder(MetadataBuildingContext buildingContext, Class<?> type, String name) {
        this.buildingContext = buildingContext;
        this.type = type;
        this.name = name;
    }

    public AdditionalMappingBuilder table(String schema, String catalog, String table) {
        this.contributors.add((context, classDetails) -> {
            TableJpaAnnotation tableUsage = (TableJpaAnnotation)classDetails.applyAnnotationUsage((AnnotationDescriptor)JpaAnnotations.TABLE, context);
            tableUsage.schema(schema);
            tableUsage.catalog(catalog);
            tableUsage.name(table);
        });
        return this;
    }

    public AdditionalMappingBuilder index(String name) {
        return this.index(name, name);
    }

    public AdditionalMappingBuilder index(String name, String columns) {
        this.contributors.add((context, classDetails) -> {
            TableJpaAnnotation tableUsage = (TableJpaAnnotation)classDetails.applyAnnotationUsage((AnnotationDescriptor)JpaAnnotations.TABLE, context);
            IndexJpaAnnotation indexUsage = (IndexJpaAnnotation)JpaAnnotations.INDEX.createUsage(context);
            indexUsage.name(name);
            indexUsage.columnList(columns);
            tableUsage.indexes(new Index[]{indexUsage});
        });
        return this;
    }

    public AdditionalMappingBuilder attribute(String name, Integer length, Boolean nullable) {
        return this.attribute(name, length, nullable, null);
    }

    public AdditionalMappingBuilder attribute(String name, Integer length, Boolean nullable, Integer type) {
        this.createAttribute(name, length, nullable, type);
        return this;
    }

    public AdditionalMappingBuilder tenantId(String name) {
        this.contributors.add((context, classDetails) -> {
            MutableMemberDetails field = (MutableMemberDetails)classDetails.findFieldByName(name);
            field.applyAnnotationUsage((AnnotationDescriptor)HibernateAnnotations.TENANT_ID, context);
        });
        return this;
    }

    public AdditionalMappingBuilder enumAttribute(String name, Integer length, Boolean nullable) {
        this.createAttribute(name, length, nullable);
        this.contributors.add((context, classDetails) -> {
            MutableMemberDetails field = (MutableMemberDetails)classDetails.findFieldByName(name);
            EnumeratedJpaAnnotation entityUsage = (EnumeratedJpaAnnotation)field.applyAnnotationUsage((AnnotationDescriptor)JpaAnnotations.ENUMERATED, context);
            entityUsage.value(EnumType.STRING);
        });
        return this;
    }

    public AdditionalMappingBuilder id(Integer type, String strategy) {
        this.contributors.add((context, classDetails) -> {
            MutableMemberDetails field = (MutableMemberDetails)classDetails.findFieldByName("id");
            field.applyAnnotationUsage((AnnotationDescriptor)JpaAnnotations.ID, context);
            UuidGeneratorAnnotation uuidGeneratorUsage = (UuidGeneratorAnnotation)field.applyAnnotationUsage((AnnotationDescriptor)HibernateAnnotations.UUID_GENERATOR, context);
            uuidGeneratorUsage.style(UuidGenerator.Style.valueOf((String)strategy.toUpperCase(Locale.ROOT)));
            if (type != null) {
                JdbcTypeCodeAnnotation jdbcTypeCodeUsage = (JdbcTypeCodeAnnotation)field.applyAnnotationUsage((AnnotationDescriptor)HibernateAnnotations.JDBC_TYPE_CODE, context);
                jdbcTypeCodeUsage.value(type.intValue());
            }
        });
        return this;
    }

    public ClassDetails build() {
        ModelsContext context = this.buildingContext.getBootstrapContext().getModelsContext();
        JdkClassDetails classDetails = JdkBuilders.buildClassDetailsStatic(this.type, (ModelsContext)context);
        EntityJpaAnnotation entityUsage = (EntityJpaAnnotation)classDetails.applyAnnotationUsage((AnnotationDescriptor)JpaAnnotations.ENTITY, context);
        entityUsage.name(this.name);
        AccessJpaAnnotation accessUsage = (AccessJpaAnnotation)classDetails.applyAnnotationUsage((AnnotationDescriptor)JpaAnnotations.ACCESS, context);
        accessUsage.value(AccessType.FIELD);
        for (BiConsumer<ModelsContext, MutableClassDetails> contributor : this.contributors) {
            contributor.accept(context, (MutableClassDetails)classDetails);
        }
        ((MutableClassDetailsRegistry)context.getClassDetailsRegistry().as(MutableClassDetailsRegistry.class)).addClassDetails(this.type.getName(), (ClassDetails)classDetails);
        return classDetails;
    }

    private void createAttribute(String name, Integer size, boolean nullable) {
        this.createAttribute(name, size, nullable, null);
    }

    private void createAttribute(String name, Integer length, boolean nullable, Integer type) {
        this.contributors.add((context, classDetails) -> {
            MutableMemberDetails field = (MutableMemberDetails)classDetails.findFieldByName(name);
            ColumnJpaAnnotation columnUsage = (ColumnJpaAnnotation)field.applyAnnotationUsage((AnnotationDescriptor)JpaAnnotations.COLUMN, context);
            columnUsage.name(name);
            columnUsage.nullable(nullable);
            if (length != null) {
                columnUsage.length(length.intValue());
            }
            if (type != null) {
                JdbcTypeCodeAnnotation jdbcTypeCodeUsage = (JdbcTypeCodeAnnotation)field.applyAnnotationUsage((AnnotationDescriptor)HibernateAnnotations.JDBC_TYPE_CODE, context);
                jdbcTypeCodeUsage.value(type.intValue());
            }
        });
    }
}

