package org.hibernate.search.mapper.orm.outboxpolling.logging.impl;

import java.util.Locale;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentState;
import java.io.Serializable;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.ClusterDescriptor;
import java.util.Set;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.ShardAssignmentDescriptor;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentReference;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.ConfigurationLog;
import java.lang.RuntimeException;
import java.util.List;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.OutboxPollingEventsLog;
import java.util.UUID;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.Agent;
import org.hibernate.search.util.common.spi.ToStringTreeAppendable;
import java.time.Instant;
import java.time.Duration;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.DeprecationLog;
import java.lang.Exception;
import java.lang.Integer;
import jakarta.persistence.PersistenceException;
import java.lang.Throwable;
import java.lang.Object;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class OutboxPollingLog_$logger implements OutboxPollingLog, org.hibernate.search.mapper.orm.outboxpolling.logging.impl.ConfigurationLog, org.hibernate.search.mapper.orm.outboxpolling.logging.impl.DeprecationLog, org.hibernate.search.mapper.orm.outboxpolling.logging.impl.OutboxPollingEventsLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = OutboxPollingLog_$logger.class.getName();
    public OutboxPollingLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void nextLoggerIdForConvenience() {
        log.logf(FQCN, TRACE, null, nextLoggerIdForConvenience$str());
    }
    protected String nextLoggerIdForConvenience$str() {
        return "HSEARCH850071: ";
    }
    @Override
    public final void outboxEventGeneratedEntityMapping(final JaxbEntityMappingsImpl mappings) {
        log.logf(FQCN, DEBUG, null, outboxEventGeneratedEntityMapping$str(), new JaxbEntityMappingsFormatter(mappings));
    }
    protected String outboxEventGeneratedEntityMapping$str() {
        return "HSEARCH850001: Generated entity mapping for outbox events used in the outbox-polling coordination strategy: %1$s";
    }
    protected String invalidTotalShardCount$str() {
        return "HSEARCH850007: The total shard count must be strictly positive.";
    }
    @Override
    public final SearchException invalidTotalShardCount() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidTotalShardCount$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidShardIndex$str() {
        return "HSEARCH850008: Shard indices must be between 0 (inclusive) and %1d (exclusive, set by '%2$s').";
    }
    @Override
    public final SearchException invalidShardIndex(final int totalShardCount, final String totalShardCountPropertyKey) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidShardIndex$str(), totalShardCount, totalShardCountPropertyKey));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingPropertyForStaticSharding$str() {
        return "HSEARCH850009: This property must be set when '%s' is set.";
    }
    @Override
    public final SearchException missingPropertyForStaticSharding(final String otherPropertyKey) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingPropertyForStaticSharding$str(), otherPropertyKey));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void eventProcessorDisabled(final String tenantId) {
        log.logf(FQCN, DEBUG, null, eventProcessorDisabled$str(), tenantId);
    }
    protected String eventProcessorDisabled$str() {
        return "HSEARCH850010: The outbox event processor is disabled for tenant '%s'.  Events will accumulate in the outbox table and indexes will not be updated, unless another application node connects to the same database with their event processor enabled.";
    }
    @Override
    public final void agentGeneratedEntityMapping(final JaxbEntityMappingsImpl xmlMappingDefinition) {
        log.logf(FQCN, DEBUG, null, agentGeneratedEntityMapping$str(), new JaxbEntityMappingsFormatter(xmlMappingDefinition));
    }
    protected String agentGeneratedEntityMapping$str() {
        return "HSEARCH850014: Generated entity mapping for agents used in the outbox-polling coordination strategy: %1$s";
    }
    protected String invalidPollingIntervalAndPulseInterval$str() {
        return "HSEARCH850015: The pulse interval must be greater than or equal to the polling interval i.e. in this case at least %s";
    }
    @Override
    public final SearchException invalidPollingIntervalAndPulseInterval(final long pollingInterval) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidPollingIntervalAndPulseInterval$str(), pollingInterval));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPulseIntervalAndPulseExpiration$str() {
        return "HSEARCH850016: The pulse expiration must be greater than or equal to 3 times the pulse interval i.e. in this case at least %s";
    }
    @Override
    public final SearchException invalidPulseIntervalAndPulseExpiration(final long pulseInterfaceTimes3) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidPulseIntervalAndPulseExpiration$str(), pulseInterfaceTimes3));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingOutboxEventBackgroundProcessorAgentTotalShardCountForStaticSharding$str() {
        return "HSEARCH850019: Agent '%1$s' is statically assigned to %2$s, but this conflicts with agent '%3$s' which expects %4$s shards. This can be a temporary situation caused by some application instances being forcibly stopped and replacements being spun up, in which case the problem will resolve itself after a few seconds once the registration of the old instances expires. However, if the situation persists, this indicates misconfiguration, with multiple application instances participating in event processing and expecting a different amount of shards; consider adjusting the configuration or switching to dynamic sharding.";
    }
    @Override
    public final SearchException conflictingOutboxEventBackgroundProcessorAgentTotalShardCountForStaticSharding(final AgentReference reference, final ShardAssignmentDescriptor staticShardAssignment, final AgentReference conflictingAgentReference, final int conflictingAgentTotalShardCount) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingOutboxEventBackgroundProcessorAgentTotalShardCountForStaticSharding$str(), reference, staticShardAssignment, conflictingAgentReference, conflictingAgentTotalShardCount));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingOutboxEventBackgroundProcessorAgentShardsForStaticSharding$str() {
        return "HSEARCH850020: Agent '%1$s' is statically assigned to %2$s, but this conflicts with agent '%3$s' which is also assigned to that shard. This can be a temporary situation caused by some application instances being forcibly stopped and replacements being spun up, in which case the problem will resolve itself after a few seconds once the registration of the old instances expires. However, if the situation persists, this indicates misconfiguration, with multiple application instances participating in event processing and being assigned to the same shard; consider adjusting the configuration or switching to dynamic sharding.";
    }
    @Override
    public final SearchException conflictingOutboxEventBackgroundProcessorAgentShardsForStaticSharding(final AgentReference reference, final ShardAssignmentDescriptor staticShardAssignment, final AgentReference conflictingAgentReference) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingOutboxEventBackgroundProcessorAgentShardsForStaticSharding$str(), reference, staticShardAssignment, conflictingAgentReference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String outboxPollingExtensionOnUnknownType$str() {
        return "HSEARCH850023: Invalid target for Outbox Polling extension: '%1$s'. This extension can only be applied when Hibernate Search is configured to use the 'outbox-polling' coordination strategy.";
    }
    @Override
    public final SearchException outboxPollingExtensionOnUnknownType(final Object context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), outboxPollingExtensionOnUnknownType$str(), context));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noTenantIdSpecified$str() {
        return "HSEARCH850024: Multi-tenancy is enabled but no tenant id is specified. Available tenants are: '%1$s'.";
    }
    @Override
    public final SearchException noTenantIdSpecified(final Set<String> tenantIds) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noTenantIdSpecified$str(), tenantIds));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiTenancyNotEnabled$str() {
        return "HSEARCH850025: Multi-tenancy is not enabled but a tenant id is specified. Trying to use the tenant id: '%1$s'.";
    }
    @Override
    public final SearchException multiTenancyNotEnabled(final String tenantId) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyNotEnabled$str(), tenantId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String agentConfigurationPropertyConflict$str() {
        return "HSEARCH850026: Outbox polling agent configuration property conflict. Either mapping property %1$s or subset of name adjustment properties %2$s should be provided at the same time.";
    }
    @Override
    public final SearchException agentConfigurationPropertyConflict(final String mappingPropertyName, final String[] nameAdjustmentProperties) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), agentConfigurationPropertyConflict$str(), mappingPropertyName, Arrays.toString(nameAdjustmentProperties)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String outboxEventConfigurationPropertyConflict$str() {
        return "HSEARCH850027: Outbox event configuration property conflict. Either mapping property %1$s or subset of name adjustment properties %2$s should be provided at the same time.";
    }
    @Override
    public final SearchException outboxEventConfigurationPropertyConflict(final String mappingPropertyName, final String[] nameAdjustmentProperties) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), outboxEventConfigurationPropertyConflict$str(), mappingPropertyName, Arrays.toString(nameAdjustmentProperties)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidUuidGenerationStrategyName$str() {
        return "HSEARCH850030: Invalid name for the UUID generation strategy: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidUuidGenerationStrategyName(final String name, final List<String> values) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidUuidGenerationStrategyName$str(), name, values));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidOutboxEventProcessingOrderName$str() {
        return "HSEARCH850031: Invalid name for the outbox event processing order: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidOutboxEventProcessingOrderName(final String name, final List<String> values) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidOutboxEventProcessingOrderName$str(), name, values));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPayloadTypeName$str() {
        return "HSEARCH850032: Invalid name for the payload type: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidPayloadTypeName(final String name, final List<String> values) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidPayloadTypeName$str(), name, values));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToProcessEntityMappings$str() {
        return "HSEARCH850035: Unable to process provided entity mappings: %1$s";
    }
    @Override
    public final SearchException unableToProcessEntityMappings(final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToProcessEntityMappings$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToParseJdbcTypeCode$str() {
        return "HSEARCH850036: Unable to parse '%1$s' as a JDBC type code or type code name. %2$s";
    }
    @Override
    public final SearchException unableToParseJdbcTypeCode(final String value, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToParseJdbcTypeCode$str(), value, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void outboxEventGeneratedEntityMappingClassDetails(final ClassDetails mappings) {
        log.logf(FQCN, DEBUG, null, outboxEventGeneratedEntityMappingClassDetails$str(), new ClassDetailsMappingsFormatter(mappings));
    }
    protected String outboxEventGeneratedEntityMappingClassDetails$str() {
        return "HSEARCH850068: Generated entity mapping for outbox events used in the outbox-polling coordination strategy: %1$s";
    }
    @Override
    public final void agentGeneratedEntityMappingClassDetails(final ClassDetails mappings) {
        log.logf(FQCN, DEBUG, null, agentGeneratedEntityMappingClassDetails$str(), new ClassDetailsMappingsFormatter(mappings));
    }
    protected String agentGeneratedEntityMappingClassDetails$str() {
        return "HSEARCH850069: Generated entity mapping for agents used in the outbox-polling coordination strategy: %1$s";
    }
    @Override
    public final void usingDeprecatedPropertyValue(final String property, final String value, final String correctValue) {
        log.logf(FQCN, WARN, null, usingDeprecatedPropertyValue$str(), property, value, correctValue);
    }
    protected String usingDeprecatedPropertyValue$str() {
        return "HSEARCH850037: Configuration property '%1$s' is configured with a deprecated value '%2$s'. Use '%3$s' instead.";
    }
    protected String maxRetryExhausted$str() {
        return "HSEARCH850003: Max '%1$s' retries exhausted to process the event. Event will be aborted.";
    }
    @Override
    public final SearchException maxRetryExhausted(final int retries) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), maxRetryExhausted$str(), retries));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void backgroundIndexingRetry(final UUID eventId, final String entityName, final String entityId, final int attempts, final Instant processAfter) {
        log.logf(FQCN, WARN, null, backgroundIndexingRetry$str(), eventId, entityName, entityId, attempts, processAfter);
    }
    protected String backgroundIndexingRetry$str() {
        return "HSEARCH850004: Background indexing failed for event #%1$s on entity of type '%2$s' with ID '%3$s'. Attempts so far: %4$d. The event will be reprocessed after the moment: %5$s.";
    }
    @Override
    public final void startingOutboxEventProcessor(final String name, final ToStringTreeAppendable processor) {
        log.logf(FQCN, DEBUG, null, startingOutboxEventProcessor$str(), name, new org.hibernate.search.util.common.logging.impl.ToStringTreeMultilineFormatter(processor));
    }
    protected String startingOutboxEventProcessor$str() {
        return "HSEARCH850005: Starting outbox event processor '%1$s': %2$s";
    }
    @Override
    public final void stoppingOutboxEventProcessor(final String name) {
        log.logf(FQCN, DEBUG, null, stoppingOutboxEventProcessor$str(), name);
    }
    protected String stoppingOutboxEventProcessor$str() {
        return "HSEARCH850006: Stopping outbox event processor '%1$s'";
    }
    @Override
    public final void outboxEventProcessorUnableToLock(final String name, final PersistenceException lockException) {
        log.logf(FQCN, DEBUG, lockException, outboxEventProcessorUnableToLock$str(), name);
    }
    protected String outboxEventProcessorUnableToLock$str() {
        return "HSEARCH850011: '%1$s' failed to obtain a lock on events to update/delete; will try again later.";
    }
    protected String unableToSerializeOutboxEventPayloadWithAvro$str() {
        return "HSEARCH850012: Unable to serialize OutboxEvent payload with Avro: %1$s";
    }
    @Override
    public final SearchException unableToSerializeOutboxEventPayloadWithAvro(final String causeMessage, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToSerializeOutboxEventPayloadWithAvro$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToDeserializeOutboxEventPayloadWithAvro$str() {
        return "HSEARCH850013: Unable to deserialize OutboxEvent payload with Avro: %1$s";
    }
    @Override
    public final SearchException unableToDeserializeOutboxEventPayloadWithAvro(final String causeMessage, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToDeserializeOutboxEventPayloadWithAvro$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String outboxEventProcessorPulse$str() {
        return "Pulse operation for agent '%1$s'";
    }
    @Override
    public final String outboxEventProcessorPulse(final AgentReference agentReference) {
        return String.format(getLoggingLocale(), outboxEventProcessorPulse$str(), agentReference);
    }
    protected String outboxEventProcessorPulseFailed$str() {
        return "HSEARCH850017: Agent '%1$s': failed to infer a target cluster from the list of registered agents. The agent will try again in the next pulse. Cause: %2$s Registered agents: %3$s.";
    }
    @Override
    public final SearchException outboxEventProcessorPulseFailed(final AgentReference agentReference, final String causeMessage, final List<Agent> allAgentsInIdOrder, final RuntimeException cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), outboxEventProcessorPulseFailed$str(), agentReference, causeMessage, allAgentsInIdOrder), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void removingTimedOutAgents(final AgentReference agentReference, final List<Agent> timedOutAgents) {
        log.logf(FQCN, WARN, null, removingTimedOutAgents$str(), agentReference, timedOutAgents);
    }
    protected String removingTimedOutAgents$str() {
        return "HSEARCH850018: Agent '%1$s': the registration of some agents in the outbox-polling strategy are considered expired and will be forcibly removed: %2$s. These agents did not update their registration in the database in time. This can be caused by invalid configuration (expiration lower than how long it takes to process a batch of events) or by an application node being forcibly stopped (disconnection from the network, application crash).";
    }
    @Override
    public final void startingOutboxMassIndexerAgent(final String name, final ToStringTreeAppendable processor) {
        log.logf(FQCN, DEBUG, null, startingOutboxMassIndexerAgent$str(), name, new org.hibernate.search.util.common.logging.impl.ToStringTreeMultilineFormatter(processor));
    }
    protected String startingOutboxMassIndexerAgent$str() {
        return "HSEARCH850021: Starting outbox mass indexer agent '%1$s': %2$s";
    }
    @Override
    public final void stoppingOutboxMassIndexerAgent(final String name) {
        log.logf(FQCN, DEBUG, null, stoppingOutboxMassIndexerAgent$str(), name);
    }
    protected String stoppingOutboxMassIndexerAgent$str() {
        return "HSEARCH850022: Stopping outbox mass indexer agent '%1$s'";
    }
    protected String agentRegistrationIneffective$str() {
        return "HSEARCH850028: Agent '%1$s': could not find the agent after starting a new transaction. The agent was present just a moment ago. Either this problem is a rare occurrence, or the pulse expiration delay is too short.";
    }
    @Override
    public final SearchException agentRegistrationIneffective(final AgentReference agentReference) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), agentRegistrationIneffective$str(), agentReference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonblockingOperationSubmitterNotSupported$str() {
        return "HSEARCH850029: Nonblocking operation submitter is not supported.";
    }
    @Override
    public final SearchException nonblockingOperationSubmitterNotSupported() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonblockingOperationSubmitterNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void eventProcessorFindEventsUnableToLock(final String name, final PersistenceException lockException) {
        log.logf(FQCN, DEBUG, lockException, eventProcessorFindEventsUnableToLock$str(), name);
    }
    protected String eventProcessorFindEventsUnableToLock$str() {
        return "HSEARCH850034: '%1$s' failed to retrieve events to process due to a locking failure; will try again later.";
    }
    @Override
    public final void agentRegistering(final AgentReference agentReference) {
        log.logf(FQCN, INFO, null, agentRegistering$str(), agentReference);
    }
    protected String agentRegistering$str() {
        return "HSEARCH850038: Agent '%s': registering.";
    }
    @Override
    public final void agentLeaving(final AgentReference agentReference) {
        log.logf(FQCN, INFO, null, agentLeaving$str(), agentReference);
    }
    protected String agentLeaving$str() {
        return "HSEARCH850039: Agent '%s': leaving cluster.";
    }
    @Override
    public final void agentSuspending(final AgentReference agentReference) {
        log.logf(FQCN, INFO, null, agentSuspending$str(), agentReference);
    }
    protected String agentSuspending$str() {
        return "HSEARCH850040: Agent '%s': suspending.";
    }
    @Override
    public final void agentWaiting(final AgentReference agentReference, final ShardAssignmentDescriptor shardAssignment, final ClusterDescriptor clusterDescriptor) {
        log.logf(FQCN, INFO, null, agentWaiting$str(), agentReference, shardAssignment, clusterDescriptor);
    }
    protected String agentWaiting$str() {
        return "HSEARCH850041: Agent '%s': waiting for cluster changes. Shard assignment: %s. Cluster: %s";
    }
    @Override
    public final void agentRunning(final AgentReference agentReference, final ShardAssignmentDescriptor shardAssignment, final ClusterDescriptor clusterDescriptor) {
        log.logf(FQCN, INFO, null, agentRunning$str(), agentReference, shardAssignment, clusterDescriptor);
    }
    protected String agentRunning$str() {
        return "HSEARCH850042: Agent '%s': running. Shard assignment: %s. Cluster: %s";
    }
    @Override
    public final void agentPulseStarting(final AgentReference agentReference, final Instant now, final Agent self, final List<Agent> allAgentsInIdOrder) {
        log.logf(FQCN, TRACE, null, agentPulseStarting$str(), agentReference, now, self, allAgentsInIdOrder);
    }
    protected String agentPulseStarting$str() {
        return "HSEARCH850043: Agent '%s': starting pulse at %s with self = %s, all agents = %s";
    }
    @Override
    public final void agentPulseEnded(final AgentReference agentReference, final Instant now, final Agent self) {
        log.logf(FQCN, TRACE, null, agentPulseEnded$str(), agentReference, now, self);
    }
    protected String agentPulseEnded$str() {
        return "HSEARCH850044: Agent '%s': ending pulse at %s with self = %s";
    }
    @Override
    public final void agentReassessing(final AgentReference agentReference) {
        log.logf(FQCN, INFO, null, agentReassessing$str(), agentReference);
    }
    protected String agentReassessing$str() {
        return "HSEARCH850045: Agent '%s': reassessing the new situation in the next pulse";
    }
    @Override
    public final void processingOutboxEvents(final int size, final String name, final List<org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEvent> events) {
        log.logf(FQCN, TRACE, null, processingOutboxEvents$str(), size, name, events);
    }
    protected String processingOutboxEvents$str() {
        return "HSEARCH850046: Processing %d outbox events for '%s': '%s'";
    }
    @Override
    public final void agentWaitingForEvents(final AgentReference agentReference, final AgentReference reference, final AgentState expectedState) {
        log.logf(FQCN, TRACE, null, agentWaitingForEvents$str(), agentReference, reference, expectedState);
    }
    protected String agentWaitingForEvents$str() {
        return "HSEARCH850047: Agent '%s': waiting for event processor '%s', which has not reached state '%s' yet";
    }
    @Override
    public final void agentProcessorsExpired(final AgentReference agentReference, final AgentState expectedState) {
        log.logf(FQCN, TRACE, null, agentProcessorsExpired$str(), agentReference, expectedState);
    }
    protected String agentProcessorsExpired$str() {
        return "HSEARCH850048: Agent '%s': all event processors reached the expected state %s";
    }
    @Override
    public final void agentHoldMassIndexing(final AgentReference agentReference, final Duration delay, final Instant expiration) {
        log.logf(FQCN, TRACE, null, agentHoldMassIndexing$str(), agentReference, delay, expiration);
    }
    protected String agentHoldMassIndexing$str() {
        return "HSEARCH850049: Agent '%s': instructions are to hold off mass indexing and to retry a pulse in %s, around %s";
    }
    @Override
    public final void agentProceedMassIndexing(final AgentReference agentReference, final Duration pulseInterval, final Instant expiration) {
        log.logf(FQCN, TRACE, null, agentProceedMassIndexing$str(), agentReference, pulseInterval, expiration);
    }
    protected String agentProceedMassIndexing$str() {
        return "HSEARCH850050: Agent '%s': instructions are to proceed with mass indexing and to retry a pulse in %s, around %s";
    }
    @Override
    public final void agentAssignmentDoesNotMatchTarget(final AgentReference agentReference, final ShardAssignmentDescriptor persistedShardAssignment, final ShardAssignmentDescriptor targetShardAssignment, final ClusterDescriptor descriptor) {
        log.logf(FQCN, INFO, null, agentAssignmentDoesNotMatchTarget$str(), agentReference, persistedShardAssignment, targetShardAssignment, descriptor);
    }
    protected String agentAssignmentDoesNotMatchTarget$str() {
        return "HSEARCH850051: Agent '%s': the persisted shard assignment (%s) does not match the target. Target assignment: %s. Cluster: %s.";
    }
    @Override
    public final void agentAssignment(final AgentReference agentReference, final ShardAssignmentDescriptor targetShardAssignment) {
        log.logf(FQCN, INFO, null, agentAssignment$str(), agentReference, targetShardAssignment);
    }
    protected String agentAssignment$str() {
        return "HSEARCH850052: Agent '%s': assigning to %s";
    }
    @Override
    public final void agentWaitingAgentReachState(final AgentReference agentReference, final AgentReference reference, final AgentState expectedState) {
        log.logf(FQCN, TRACE, null, agentWaitingAgentReachState$str(), agentReference, reference, expectedState);
    }
    protected String agentWaitingAgentReachState$str() {
        return "HSEARCH850053: Agent '%s': waiting for agent '%s', which has not reached state '%s' yet";
    }
    @Override
    public final void agentExcluded(final AgentReference agentReference, final AgentState expectedState) {
        log.logf(FQCN, TRACE, null, agentExcluded$str(), agentReference, expectedState);
    }
    protected String agentExcluded$str() {
        return "HSEARCH850054: Agent '%s': agents excluded from the cluster reached the expected state %s";
    }
    @Override
    public final void instructCommitAndRetryPulseAfterDelay(final AgentReference agentReference, final Duration delay, final Instant expiration) {
        log.logf(FQCN, TRACE, null, instructCommitAndRetryPulseAfterDelay$str(), agentReference, delay, expiration);
    }
    protected String instructCommitAndRetryPulseAfterDelay$str() {
        return "HSEARCH850055: Agent '%s': instructions are to not process events and to retry a pulse in %s, around %s";
    }
    @Override
    public final void instructProceedWithEventProcessing(final AgentReference agentReference, final Duration pulseInterval, final Instant expiration) {
        log.logf(FQCN, TRACE, null, instructProceedWithEventProcessing$str(), agentReference, pulseInterval, expiration);
    }
    protected String instructProceedWithEventProcessing$str() {
        return "HSEARCH850056: Agent '%s': instructions are to process events and to retry a pulse in %s, around %s";
    }
    @Override
    public final void clusterMembersAreInClusterWaitingForState(final AgentReference agentReference, final AgentReference reference, final AgentState state, final Set<AgentState> expectedStates) {
        log.logf(FQCN, TRACE, null, clusterMembersAreInClusterWaitingForState$str(), agentReference, reference, state, expectedStates);
    }
    protected String clusterMembersAreInClusterWaitingForState$str() {
        return "HSEARCH850057: Agent '%s': waiting for agent '%s', whose state %s is not in the expected %s yet";
    }
    @Override
    public final void clusterMembersAreInClusterShardCountExpectation(final AgentReference agentReference, final AgentReference reference, final Integer totalShardCount, final int expectedTotalShardCount) {
        log.logf(FQCN, TRACE, null, clusterMembersAreInClusterShardCountExpectation$str(), agentReference, reference, totalShardCount, expectedTotalShardCount);
    }
    protected String clusterMembersAreInClusterShardCountExpectation$str() {
        return "HSEARCH850058: Agent '%s': waiting for agent '%s', whose total shard count %s is not the expected %s yet";
    }
    @Override
    public final void clusterMembersAreInClusterSharIndexExpectation(final AgentReference agentReference, final AgentReference reference, final Integer assignedShardIndex, final int expectedAssignedShardIndex) {
        log.logf(FQCN, TRACE, null, clusterMembersAreInClusterSharIndexExpectation$str(), agentReference, reference, assignedShardIndex, expectedAssignedShardIndex);
    }
    protected String clusterMembersAreInClusterSharIndexExpectation$str() {
        return "HSEARCH850059: Agent '%s': waiting for agent '%s', whose assigned shard index %s is not the expected %s yet";
    }
    @Override
    public final void clusterMembersAreInClusterReachedExpectedStates(final AgentReference agentReference, final Set<AgentState> expectedStates, final ClusterDescriptor clusterDescriptor) {
        log.logf(FQCN, TRACE, null, clusterMembersAreInClusterReachedExpectedStates$str(), agentReference, expectedStates, clusterDescriptor);
    }
    protected String clusterMembersAreInClusterReachedExpectedStates$str() {
        return "HSEARCH850060: Agent '%s': all cluster members reached the expected states %s and shard assignment %s";
    }
    @Override
    public final void agentClusterMembersMissingInfo(final AgentReference agentReference, final ClusterDescriptor descriptor) {
        log.logf(FQCN, INFO, null, agentClusterMembersMissingInfo$str(), agentReference, descriptor);
    }
    protected String agentClusterMembersMissingInfo$str() {
        return "HSEARCH850061: Agent '%s': some cluster members are missing; this agent will wait until they are present. Target cluster: %s.";
    }
    @Override
    public final void agentClusterMembersMissingTrace(final AgentReference agentReference, final ClusterDescriptor descriptor) {
        log.logf(FQCN, TRACE, null, agentClusterMembersMissingTrace$str(), agentReference, descriptor);
    }
    protected String agentClusterMembersMissingTrace$str() {
        return "HSEARCH850062: Agent '%s': some cluster members are missing; this agent will wait until they are present. Target cluster: %s.";
    }
    @Override
    public final void agentSuperfluousInfo(final AgentReference agentReference, final ClusterDescriptor descriptor) {
        log.logf(FQCN, INFO, null, agentSuperfluousInfo$str(), agentReference, descriptor);
    }
    protected String agentSuperfluousInfo$str() {
        return "HSEARCH850063: Agent '%s': this agent is superfluous and will not perform event processing, because other agents are enough to handle all the shards. Target cluster: %s.";
    }
    @Override
    public final void agentSuperfluousTrace(final AgentReference agentReference, final ClusterDescriptor descriptor) {
        log.logf(FQCN, TRACE, null, agentSuperfluousTrace$str(), agentReference, descriptor);
    }
    protected String agentSuperfluousTrace$str() {
        return "HSEARCH850064: Agent '%s': this agent is superfluous and will not perform event processing, because other agents are enough to handle all the shards. Target cluster: %s.";
    }
    @Override
    public final void agentOtherAgentIsIndexingInfo(final AgentReference agentReference, final Agent agent) {
        log.logf(FQCN, INFO, null, agentOtherAgentIsIndexingInfo$str(), agentReference, agent);
    }
    protected String agentOtherAgentIsIndexingInfo$str() {
        return "HSEARCH850065: Agent '%s': another agent '%s' is currently mass indexing";
    }
    @Override
    public final void agentOtherAgentIsIndexingTrace(final AgentReference agentReference, final Agent agent) {
        log.logf(FQCN, TRACE, null, agentOtherAgentIsIndexingTrace$str(), agentReference, agent);
    }
    protected String agentOtherAgentIsIndexingTrace$str() {
        return "HSEARCH850066: Agent '%s': another agent '%s' is currently mass indexing";
    }
    @Override
    public final void eventPlanNumberOfPersistedEvents(final int size, final List<org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEvent> events) {
        log.logf(FQCN, TRACE, null, eventPlanNumberOfPersistedEvents$str(), size, events);
    }
    protected String eventPlanNumberOfPersistedEvents$str() {
        return "HSEARCH850067: Persisted %d outbox events: '%s'";
    }
    @Override
    public final void eventLockingRetryLimitReached(final AgentReference agentReference, final int numberOfRetries, final Set<UUID> events) {
        log.logf(FQCN, WARN, null, eventLockingRetryLimitReached$str(), agentReference, numberOfRetries, events);
    }
    protected String eventLockingRetryLimitReached$str() {
        return "HSEARCH850070: Agent '%s': after %d retries, failed to acquire a lock on the following outbox events: %s. Events will be re-processed at a later time.";
    }
}
