package org.hibernate.search.mapper.orm.outboxpolling.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import java.util.Set;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.ShardAssignmentDescriptor;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentReference;
import java.lang.Object;
import java.util.List;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class ConfigurationLog_$logger implements ConfigurationLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ConfigurationLog_$logger.class.getName();
    public ConfigurationLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void outboxEventGeneratedEntityMapping(final JaxbEntityMappingsImpl mappings) {
        log.logf(FQCN, DEBUG, null, outboxEventGeneratedEntityMapping$str(), new JaxbEntityMappingsFormatter(mappings));
    }
    protected String outboxEventGeneratedEntityMapping$str() {
        return "HSEARCH850001: Generated entity mapping for outbox events used in the outbox-polling coordination strategy: %1$s";
    }
    protected String invalidTotalShardCount$str() {
        return "HSEARCH850007: The total shard count must be strictly positive.";
    }
    @Override
    public final SearchException invalidTotalShardCount() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidTotalShardCount$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidShardIndex$str() {
        return "HSEARCH850008: Shard indices must be between 0 (inclusive) and %1d (exclusive, set by '%2$s').";
    }
    @Override
    public final SearchException invalidShardIndex(final int totalShardCount, final String totalShardCountPropertyKey) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidShardIndex$str(), totalShardCount, totalShardCountPropertyKey));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingPropertyForStaticSharding$str() {
        return "HSEARCH850009: This property must be set when '%s' is set.";
    }
    @Override
    public final SearchException missingPropertyForStaticSharding(final String otherPropertyKey) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingPropertyForStaticSharding$str(), otherPropertyKey));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void eventProcessorDisabled(final String tenantId) {
        log.logf(FQCN, DEBUG, null, eventProcessorDisabled$str(), tenantId);
    }
    protected String eventProcessorDisabled$str() {
        return "HSEARCH850010: The outbox event processor is disabled for tenant '%s'.  Events will accumulate in the outbox table and indexes will not be updated, unless another application node connects to the same database with their event processor enabled.";
    }
    @Override
    public final void agentGeneratedEntityMapping(final JaxbEntityMappingsImpl xmlMappingDefinition) {
        log.logf(FQCN, DEBUG, null, agentGeneratedEntityMapping$str(), new JaxbEntityMappingsFormatter(xmlMappingDefinition));
    }
    protected String agentGeneratedEntityMapping$str() {
        return "HSEARCH850014: Generated entity mapping for agents used in the outbox-polling coordination strategy: %1$s";
    }
    protected String invalidPollingIntervalAndPulseInterval$str() {
        return "HSEARCH850015: The pulse interval must be greater than or equal to the polling interval i.e. in this case at least %s";
    }
    @Override
    public final SearchException invalidPollingIntervalAndPulseInterval(final long pollingInterval) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidPollingIntervalAndPulseInterval$str(), pollingInterval));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPulseIntervalAndPulseExpiration$str() {
        return "HSEARCH850016: The pulse expiration must be greater than or equal to 3 times the pulse interval i.e. in this case at least %s";
    }
    @Override
    public final SearchException invalidPulseIntervalAndPulseExpiration(final long pulseInterfaceTimes3) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidPulseIntervalAndPulseExpiration$str(), pulseInterfaceTimes3));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingOutboxEventBackgroundProcessorAgentTotalShardCountForStaticSharding$str() {
        return "HSEARCH850019: Agent '%1$s' is statically assigned to %2$s, but this conflicts with agent '%3$s' which expects %4$s shards. This can be a temporary situation caused by some application instances being forcibly stopped and replacements being spun up, in which case the problem will resolve itself after a few seconds once the registration of the old instances expires. However, if the situation persists, this indicates misconfiguration, with multiple application instances participating in event processing and expecting a different amount of shards; consider adjusting the configuration or switching to dynamic sharding.";
    }
    @Override
    public final SearchException conflictingOutboxEventBackgroundProcessorAgentTotalShardCountForStaticSharding(final AgentReference reference, final ShardAssignmentDescriptor staticShardAssignment, final AgentReference conflictingAgentReference, final int conflictingAgentTotalShardCount) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingOutboxEventBackgroundProcessorAgentTotalShardCountForStaticSharding$str(), reference, staticShardAssignment, conflictingAgentReference, conflictingAgentTotalShardCount));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingOutboxEventBackgroundProcessorAgentShardsForStaticSharding$str() {
        return "HSEARCH850020: Agent '%1$s' is statically assigned to %2$s, but this conflicts with agent '%3$s' which is also assigned to that shard. This can be a temporary situation caused by some application instances being forcibly stopped and replacements being spun up, in which case the problem will resolve itself after a few seconds once the registration of the old instances expires. However, if the situation persists, this indicates misconfiguration, with multiple application instances participating in event processing and being assigned to the same shard; consider adjusting the configuration or switching to dynamic sharding.";
    }
    @Override
    public final SearchException conflictingOutboxEventBackgroundProcessorAgentShardsForStaticSharding(final AgentReference reference, final ShardAssignmentDescriptor staticShardAssignment, final AgentReference conflictingAgentReference) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingOutboxEventBackgroundProcessorAgentShardsForStaticSharding$str(), reference, staticShardAssignment, conflictingAgentReference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String outboxPollingExtensionOnUnknownType$str() {
        return "HSEARCH850023: Invalid target for Outbox Polling extension: '%1$s'. This extension can only be applied when Hibernate Search is configured to use the 'outbox-polling' coordination strategy.";
    }
    @Override
    public final SearchException outboxPollingExtensionOnUnknownType(final Object context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), outboxPollingExtensionOnUnknownType$str(), context));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noTenantIdSpecified$str() {
        return "HSEARCH850024: Multi-tenancy is enabled but no tenant id is specified. Available tenants are: '%1$s'.";
    }
    @Override
    public final SearchException noTenantIdSpecified(final Set<String> tenantIds) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noTenantIdSpecified$str(), tenantIds));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiTenancyNotEnabled$str() {
        return "HSEARCH850025: Multi-tenancy is not enabled but a tenant id is specified. Trying to use the tenant id: '%1$s'.";
    }
    @Override
    public final SearchException multiTenancyNotEnabled(final String tenantId) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyNotEnabled$str(), tenantId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String agentConfigurationPropertyConflict$str() {
        return "HSEARCH850026: Outbox polling agent configuration property conflict. Either mapping property %1$s or subset of name adjustment properties %2$s should be provided at the same time.";
    }
    @Override
    public final SearchException agentConfigurationPropertyConflict(final String mappingPropertyName, final String[] nameAdjustmentProperties) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), agentConfigurationPropertyConflict$str(), mappingPropertyName, Arrays.toString(nameAdjustmentProperties)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String outboxEventConfigurationPropertyConflict$str() {
        return "HSEARCH850027: Outbox event configuration property conflict. Either mapping property %1$s or subset of name adjustment properties %2$s should be provided at the same time.";
    }
    @Override
    public final SearchException outboxEventConfigurationPropertyConflict(final String mappingPropertyName, final String[] nameAdjustmentProperties) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), outboxEventConfigurationPropertyConflict$str(), mappingPropertyName, Arrays.toString(nameAdjustmentProperties)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidUuidGenerationStrategyName$str() {
        return "HSEARCH850030: Invalid name for the UUID generation strategy: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidUuidGenerationStrategyName(final String name, final List<String> values) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidUuidGenerationStrategyName$str(), name, values));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidOutboxEventProcessingOrderName$str() {
        return "HSEARCH850031: Invalid name for the outbox event processing order: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidOutboxEventProcessingOrderName(final String name, final List<String> values) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidOutboxEventProcessingOrderName$str(), name, values));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPayloadTypeName$str() {
        return "HSEARCH850032: Invalid name for the payload type: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidPayloadTypeName(final String name, final List<String> values) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidPayloadTypeName$str(), name, values));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToProcessEntityMappings$str() {
        return "HSEARCH850035: Unable to process provided entity mappings: %1$s";
    }
    @Override
    public final SearchException unableToProcessEntityMappings(final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToProcessEntityMappings$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToParseJdbcTypeCode$str() {
        return "HSEARCH850036: Unable to parse '%1$s' as a JDBC type code or type code name. %2$s";
    }
    @Override
    public final SearchException unableToParseJdbcTypeCode(final String value, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToParseJdbcTypeCode$str(), value, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void outboxEventGeneratedEntityMappingClassDetails(final ClassDetails mappings) {
        log.logf(FQCN, DEBUG, null, outboxEventGeneratedEntityMappingClassDetails$str(), new ClassDetailsMappingsFormatter(mappings));
    }
    protected String outboxEventGeneratedEntityMappingClassDetails$str() {
        return "HSEARCH850068: Generated entity mapping for outbox events used in the outbox-polling coordination strategy: %1$s";
    }
    @Override
    public final void agentGeneratedEntityMappingClassDetails(final ClassDetails mappings) {
        log.logf(FQCN, DEBUG, null, agentGeneratedEntityMappingClassDetails$str(), new ClassDetailsMappingsFormatter(mappings));
    }
    protected String agentGeneratedEntityMappingClassDetails$str() {
        return "HSEARCH850069: Generated entity mapping for agents used in the outbox-polling coordination strategy: %1$s";
    }
}
