/*
 * SPDX-License-Identifier: Apache-2.0
 * Copyright Red Hat Inc. and Hibernate Authors
 */
package org.hibernate.search.mapper.orm.outboxpolling.cluster.impl;

import java.time.Instant;
import java.util.UUID;

import jakarta.persistence.Transient;

public class Agent {
	private UUID id;
	private AgentType type;
	private String name;
	private Instant expiration;
	private AgentState state;
	private Integer totalShardCount;
	private Integer assignedShardIndex;
	private byte[] payload;
	private String tenantId;

	protected Agent() {
	}

	public Agent(AgentType type, String name, Instant expiration, AgentState state,
			ShardAssignmentDescriptor shardAssignment) {
		this.type = type;
		this.name = name;
		this.expiration = expiration;
		this.state = state;
		this.totalShardCount = shardAssignment == null ? null : shardAssignment.totalShardCount;
		this.assignedShardIndex = shardAssignment == null ? null : shardAssignment.assignedShardIndex;
	}

	@Override
	public String toString() {
		return "Agent{" +
				"id=" + id +
				", name='" + name + '\'' +
				", expiration=" + expiration +
				", type=" + type +
				", currentState=" + state +
				", totalShardCount=" + totalShardCount +
				", assignedShardIndex=" + assignedShardIndex +
				", tenantId=" + tenantId +
				'}';
	}

	public UUID getId() {
		return id;
	}

	// For tests only
	public void setId(UUID id) {
		this.id = id;
	}

	public AgentType getType() {
		return type;
	}

	public void setType(AgentType type) {
		this.type = type;
	}

	public String getName() {
		return name;
	}

	protected void setName(String name) {
		this.name = name;
	}

	public Instant getExpiration() {
		return expiration;
	}

	public void setExpiration(Instant expiration) {
		this.expiration = expiration;
	}

	public AgentState getState() {
		return state;
	}

	public void setState(AgentState state) {
		this.state = state;
	}

	public Integer getTotalShardCount() {
		return totalShardCount;
	}

	public void setTotalShardCount(Integer totalShardCount) {
		this.totalShardCount = totalShardCount;
	}

	public Integer getAssignedShardIndex() {
		return assignedShardIndex;
	}

	public void setAssignedShardIndex(Integer assignedShardIndex) {
		this.assignedShardIndex = assignedShardIndex;
	}

	public byte[] getPayload() {
		return payload;
	}

	public void setPayload(byte[] payload) {
		this.payload = payload;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	@Transient
	public AgentReference getReference() {
		return AgentReference.of( id, name );
	}

	@Transient
	public ShardAssignmentDescriptor getShardAssignment() {
		return ( totalShardCount == null || assignedShardIndex == null )
				? null
				: new ShardAssignmentDescriptor( totalShardCount, assignedShardIndex );
	}
}
