/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.event.impl;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEvent;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEventAndPredicate;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEventFinder;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEventFinderProvider;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEventOrder;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEventPredicate;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxPollingOutboxEventAdditionalJaxbMappingProducer;
import org.hibernate.search.util.common.spi.ToStringTreeAppender;

public final class DefaultOutboxEventFinder
implements OutboxEventFinder {
    private static final OutboxEventAndPredicate BASE_PREDICATE_FILTER = OutboxEventAndPredicate.of(new ProcessAfterFilter(), new ProcessPendingFilter());
    private final String queryString;
    private final Optional<OutboxEventPredicate> predicate;
    private final OutboxEventOrder order;

    private DefaultOutboxEventFinder(Optional<OutboxEventPredicate> predicate, OutboxEventOrder order) {
        this.queryString = this.createQueryString(predicate, alias -> alias, order);
        this.predicate = predicate;
        this.order = order;
    }

    @Override
    public List<OutboxEvent> findOutboxEvents(Session session, int maxResults) {
        Query<OutboxEvent> query = this.createOutboxEventQuery(session);
        query.setMaxResults(maxResults);
        return query.list();
    }

    public Query<OutboxEvent> createOutboxEventQuery(Session session) {
        Query query = session.createQuery(this.queryString, OutboxEvent.class);
        if (this.predicate.isPresent()) {
            this.predicate.get().setParams(query);
        }
        return query;
    }

    public <T> Query<T> createOutboxEventQueryForTests(Session session, Function<String, String> selectClauseFunction, Class<T> resultType, OutboxEventOrder order) {
        String queryStringForTests = this.createQueryString(this.predicate, selectClauseFunction, order != null ? order : this.order);
        Query query = session.createQuery(queryStringForTests, resultType);
        if (this.predicate.isPresent()) {
            this.predicate.get().setParams(query);
        }
        return query;
    }

    private String createQueryString(Optional<OutboxEventPredicate> predicate, Function<String, String> selectClauseFunction, OutboxEventOrder order) {
        return "select " + selectClauseFunction.apply("e") + " from " + OutboxPollingOutboxEventAdditionalJaxbMappingProducer.ENTITY_NAME + " e " + (String)(predicate.isPresent() ? " where " + predicate.get().queryPart("e") : "") + order.queryPart("e");
    }

    private static class ProcessAfterFilter
    implements OutboxEventPredicate {
        private ProcessAfterFilter() {
        }

        @Override
        public String queryPart(String eventAlias) {
            return eventAlias + ".processAfter < :now";
        }

        @Override
        public void setParams(Query<?> query) {
            query.setParameter("now", (Object)Instant.now());
        }
    }

    private static class ProcessPendingFilter
    implements OutboxEventPredicate {
        private ProcessPendingFilter() {
        }

        @Override
        public String queryPart(String eventAlias) {
            return eventAlias + ".status = :status";
        }

        @Override
        public void setParams(Query<?> query) {
            query.setParameter("status", (Object)OutboxEvent.Status.PENDING);
        }
    }

    public static final class Provider
    extends OutboxEventFinderProvider {
        private final OutboxEventOrder order;

        public Provider(OutboxEventOrder order) {
            this.order = order;
        }

        public void appendTo(ToStringTreeAppender appender) {
            appender.attribute("order", (Object)this.order);
        }

        @Override
        public DefaultOutboxEventFinder create(Optional<OutboxEventPredicate> predicate) {
            OutboxEventAndPredicate combined = predicate.isPresent() ? OutboxEventAndPredicate.of(predicate.get(), BASE_PREDICATE_FILTER) : BASE_PREDICATE_FILTER;
            return new DefaultOutboxEventFinder(Optional.of(combined), this.order);
        }

        public DefaultOutboxEventFinder createWithoutStatusOrProcessAfterFilter() {
            return new DefaultOutboxEventFinder(Optional.empty(), this.order);
        }
    }
}

