/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jakarta.batch.jberet.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jberet.spi.JobXmlResolver;
import org.jberet.tools.AbstractJobXmlResolver;

public final class HibernateSearchJobXmlResolver
extends AbstractJobXmlResolver
implements JobXmlResolver {
    private static final String XML_SUFFIX = ".xml";
    private static final Map<String, String> JOB_XML_NAMES_TO_JOB_NAMES = Collections.unmodifiableMap(Arrays.asList("hibernate-search-mass-indexing").stream().collect(Collectors.toMap(s -> s.concat(XML_SUFFIX), Function.identity())));

    public Collection<String> getJobXmlNames(ClassLoader classLoader) {
        return JOB_XML_NAMES_TO_JOB_NAMES.keySet();
    }

    public String resolveJobName(String jobXml, ClassLoader classLoader) {
        return JOB_XML_NAMES_TO_JOB_NAMES.get(jobXml);
    }

    public InputStream resolveJobXml(String jobXml, ClassLoader classLoader) throws IOException {
        if (JOB_XML_NAMES_TO_JOB_NAMES.containsKey(jobXml)) {
            String path = "META-INF/batch-jobs/" + jobXml;
            return classLoader.getResourceAsStream(path);
        }
        return null;
    }
}

