/*
 * SPDX-License-Identifier: Apache-2.0
 * Copyright Red Hat Inc. and Hibernate Authors
 */
package org.hibernate.search.engine.search.predicate.dsl;

/**
 * The step in a "match" predicate definition where the value to match can be set
 * (see the superinterface {@link MatchPredicateMatchingStep}),
 * or optional parameters for the last targeted field(s) can be set,
 * or more target fields can be added.
 *
 * @param <S> The "self" type (the actual exposed type of this step).
 * @param <N> The type of the next step.
 */
public interface MatchPredicateFieldMoreStep<
		S extends MatchPredicateFieldMoreStep<?, N>,
		N extends MatchPredicateOptionsStep<?>>
		extends MatchPredicateMatchingStep<N>, MatchPredicateFieldMoreGenericStep<S, N, Object, String> {

}
