/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.projection.definition.spi;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.search.projection.ProjectionCollector;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.definition.ProjectionDefinitionContext;
import org.hibernate.search.engine.search.projection.definition.spi.AbstractProjectionDefinition;
import org.hibernate.search.util.common.annotation.Incubating;
import org.hibernate.search.util.common.spi.ToStringTreeAppender;

@Incubating
public final class ConstantProjectionDefinition<T>
extends AbstractProjectionDefinition<T> {
    private static final BeanHolder<? extends ConstantProjectionDefinition> NULL_VALUE_INSTANCE = BeanHolder.of(new ConstantProjectionDefinition<Object>(null));
    private static final BeanHolder<? extends ConstantProjectionDefinition> EMPTY_LIST_INSTANCE = BeanHolder.of(new ConstantProjectionDefinition(Collections.emptyList()));
    private static final BeanHolder<? extends ConstantProjectionDefinition> EMPTY_SET_INSTANCE = BeanHolder.of(new ConstantProjectionDefinition(Collections.emptySet()));
    private static final BeanHolder<? extends ConstantProjectionDefinition> EMPTY_SORTED_SET_INSTANCE = BeanHolder.of(new ConstantProjectionDefinition(Collections.emptySortedSet()));
    private static final BeanHolder<? extends ConstantProjectionDefinition> OPTIONAL_EMPTY_INSTANCE = BeanHolder.of(new ConstantProjectionDefinition(Optional.empty()));
    private final T value;

    public static <T> BeanHolder<ConstantProjectionDefinition<T>> nullValue() {
        return NULL_VALUE_INSTANCE;
    }

    @Deprecated(since="8.0")
    public static <T> BeanHolder<ConstantProjectionDefinition<List<T>>> emptyList() {
        return EMPTY_LIST_INSTANCE;
    }

    public static <T> BeanHolder<ConstantProjectionDefinition<T>> empty(ProjectionCollector.Provider<?, T> collector) {
        T empty = collector.get().empty();
        if (ProjectionCollector.nullable().equals(collector)) {
            return ConstantProjectionDefinition.nullValue();
        }
        if (ProjectionCollector.optional().equals(collector)) {
            return OPTIONAL_EMPTY_INSTANCE;
        }
        if (ProjectionCollector.list().equals(collector)) {
            return EMPTY_LIST_INSTANCE;
        }
        if (ProjectionCollector.set().equals(collector)) {
            return EMPTY_SET_INSTANCE;
        }
        if (empty instanceof SortedSet) {
            return EMPTY_SORTED_SET_INSTANCE;
        }
        return BeanHolder.of(new ConstantProjectionDefinition<T>(empty));
    }

    private ConstantProjectionDefinition(T value) {
        this.value = value;
    }

    @Override
    protected String type() {
        return "constant";
    }

    @Override
    public void appendTo(ToStringTreeAppender appender) {
        super.appendTo(appender);
        appender.attribute("value", this.value);
    }

    @Override
    public SearchProjection<T> create(ProjectionDefinitionContext context) {
        return context.projection().constant(this.value).toProjection();
    }
}

