/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.classpath.spi;

import org.hibernate.search.engine.environment.classpath.spi.AggregatedClassLoader;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.logging.impl.EngineMiscLog;
import org.hibernate.search.util.common.annotation.Incubating;

public final class DefaultClassResolver
implements ClassResolver {
    private final AggregatedClassLoader aggregatedClassLoader;

    public static ClassResolver create(AggregatedClassLoader aggregatedClassLoader) {
        return new DefaultClassResolver(aggregatedClassLoader);
    }

    private DefaultClassResolver(AggregatedClassLoader aggregatedClassLoader) {
        this.aggregatedClassLoader = aggregatedClassLoader;
    }

    @Override
    public Class<?> classForName(String className) {
        try {
            return Class.forName(className, true, this.aggregatedClassLoader);
        }
        catch (Exception | LinkageError e) {
            throw EngineMiscLog.INSTANCE.unableToLoadTheClass(className, e.getMessage(), e);
        }
    }

    @Override
    public Package packageForName(String packageName) {
        try {
            return Class.forName(packageName + ".package-info", true, this.aggregatedClassLoader).getPackage();
        }
        catch (Exception | LinkageError e) {
            return null;
        }
    }

    @Incubating
    public AggregatedClassLoader aggregatedClassLoader() {
        return this.aggregatedClassLoader;
    }
}

