/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.spi;

import java.util.Objects;
import java.util.function.Predicate;
import org.hibernate.search.util.common.annotation.Incubating;

@Incubating
public final class ConfigurationScope {
    public static final ConfigurationScope GLOBAL = new ConfigurationScope(null, "global", null);
    private final ConfigurationScope parent;
    private final String namespace;
    private final String name;

    private ConfigurationScope(ConfigurationScope parent, String namespace, String name) {
        this.parent = parent;
        this.namespace = namespace;
        this.name = name;
    }

    public ConfigurationScope reduce(String namespace, String name) {
        return new ConfigurationScope(this, namespace, name);
    }

    public boolean matchAny(String namespace) {
        return this.namespace.equals(namespace);
    }

    public boolean matchExact(String namespace) {
        return this.matchExact(namespace, null);
    }

    public boolean matchExact(String namespace, String name) {
        return this.matchAny(namespace) && Objects.equals(this.name, name);
    }

    public boolean match(Predicate<ConfigurationScope> predicate) {
        return predicate.test(this);
    }

    public ConfigurationScope parent() {
        return this.parent;
    }

    public String namespace() {
        return this.namespace;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return (String)(this.parent == null ? "" : String.valueOf(this.parent) + ": ") + this.namespace + (String)(this.name == null ? "" : "(" + this.name + ")");
    }
}

