/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.types.spi;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldTypeDescriptor;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.converter.FromDocumentValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.backend.types.spi.AbstractIndexNodeType;
import org.hibernate.search.engine.search.common.spi.SearchIndexScope;
import org.hibernate.search.engine.search.common.spi.SearchIndexValueFieldContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexValueFieldTypeContext;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;

public abstract class AbstractIndexValueFieldType<SC extends SearchIndexScope<?>, N extends SearchIndexValueFieldContext<SC>, F>
extends AbstractIndexNodeType<SC, N>
implements IndexValueFieldTypeDescriptor,
IndexFieldType<F>,
SearchIndexValueFieldTypeContext<SC, N, F> {
    private final Class<F> valueClass;
    private final DslConverter<F, F> indexDslConverter;
    private final ProjectionConverter<F, F> indexProjectionConverter;
    private final DslConverter<?, F> mappingDslConverter;
    private final ProjectionConverter<F, ?> mappingProjectionConverter;
    private final DslConverter<?, F> parseConverter;
    private final ProjectionConverter<F, ?> formatConverter;
    private final boolean searchable;
    private final boolean sortable;
    private final boolean projectable;
    private final boolean aggregable;
    private final boolean multivaluable;
    private final Set<SearchHighlighterType> allowedHighlighterTypes;
    private final String analyzerName;
    private final String searchAnalyzerName;
    private final String normalizerName;

    protected AbstractIndexValueFieldType(Builder<SC, N, F> builder) {
        super(builder);
        this.valueClass = builder.valueClass;
        this.indexDslConverter = builder.indexDslConverter;
        this.indexProjectionConverter = builder.indexProjectionConverter;
        this.mappingDslConverter = builder.mappingDslConverter != null ? builder.mappingDslConverter : this.indexDslConverter;
        this.mappingProjectionConverter = builder.mappingProjectionConverter != null ? builder.mappingProjectionConverter : this.indexProjectionConverter;
        this.parseConverter = builder.parser != null ? builder.parser : this.indexDslConverter;
        this.formatConverter = builder.formatter != null ? builder.formatter : this.indexProjectionConverter;
        this.searchable = builder.searchable;
        this.sortable = builder.sortable;
        this.projectable = builder.projectable;
        this.aggregable = builder.aggregable;
        this.multivaluable = builder.multivaluable;
        this.allowedHighlighterTypes = Collections.unmodifiableSet(builder.allowedHighlighterTypes);
        this.analyzerName = builder.analyzerName;
        this.searchAnalyzerName = builder.searchAnalyzerName != null ? builder.searchAnalyzerName : builder.analyzerName;
        this.normalizerName = builder.normalizerName;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[valueClass=" + this.valueClass.getName() + ", analyzerName=" + this.analyzerName + ", searchAnalyzerName=" + this.searchAnalyzerName + ", normalizerName=" + this.normalizerName + ", traits=" + String.valueOf(this.traits()) + "]";
    }

    @Override
    public final Class<F> valueClass() {
        return this.valueClass;
    }

    @Override
    public final boolean searchable() {
        return this.searchable;
    }

    @Override
    public final boolean sortable() {
        return this.sortable;
    }

    @Override
    public final boolean projectable() {
        return this.projectable;
    }

    @Override
    public final boolean aggregable() {
        return this.aggregable;
    }

    @Override
    public boolean multivaluable() {
        return this.multivaluable;
    }

    @Override
    public final Class<?> dslArgumentClass() {
        return this.mappingDslConverter.valueType();
    }

    @Override
    public final DslConverter<?, F> mappingDslConverter() {
        return this.mappingDslConverter;
    }

    @Override
    public DslConverter<?, F> parserDslConverter() {
        return this.parseConverter;
    }

    @Override
    public ProjectionConverter<F, ?> formatterProjectionConverter() {
        return this.formatConverter;
    }

    @Override
    public final DslConverter<F, F> indexDslConverter() {
        return this.indexDslConverter;
    }

    @Override
    public final Class<?> projectedValueClass() {
        return this.mappingProjectionConverter.valueType();
    }

    @Override
    public final ProjectionConverter<F, ?> mappingProjectionConverter() {
        return this.mappingProjectionConverter;
    }

    @Override
    public final ProjectionConverter<F, F> indexProjectionConverter() {
        return this.indexProjectionConverter;
    }

    @Override
    public final Optional<String> analyzerName() {
        return Optional.ofNullable(this.analyzerName);
    }

    @Override
    public final Optional<String> normalizerName() {
        return Optional.ofNullable(this.normalizerName);
    }

    @Override
    public final Optional<String> searchAnalyzerName() {
        return Optional.ofNullable(this.searchAnalyzerName);
    }

    @Override
    public boolean highlighterTypeSupported(SearchHighlighterType type) {
        return this.allowedHighlighterTypes.contains((Object)type);
    }

    public static abstract class Builder<SC extends SearchIndexScope<?>, N extends SearchIndexValueFieldContext<SC>, F>
    extends AbstractIndexNodeType.Builder<SC, N> {
        private final Class<F> valueClass;
        private final DslConverter<F, F> indexDslConverter;
        private final ProjectionConverter<F, F> indexProjectionConverter;
        private DslConverter<?, F> mappingDslConverter;
        private ProjectionConverter<F, ?> mappingProjectionConverter;
        private DslConverter<?, F> parser;
        private ProjectionConverter<F, ?> formatter;
        private boolean searchable;
        private boolean sortable;
        private boolean projectable;
        private boolean aggregable;
        private boolean multivaluable = true;
        private Set<SearchHighlighterType> allowedHighlighterTypes = Collections.emptySet();
        private String analyzerName;
        private String searchAnalyzerName;
        private String normalizerName;

        public Builder(Class<F> valueClass) {
            this.valueClass = valueClass;
            this.indexDslConverter = DslConverter.passThrough(valueClass);
            this.indexProjectionConverter = ProjectionConverter.passThrough(valueClass);
        }

        public final Class<F> valueClass() {
            return this.valueClass;
        }

        public final <V> void dslConverter(Class<V> valueType, ToDocumentValueConverter<V, ? extends F> toIndexConverter) {
            this.mappingDslConverter = new DslConverter<V, F>(valueType, toIndexConverter);
        }

        public final <V> void projectionConverter(Class<V> valueType, FromDocumentValueConverter<? super F, V> fromIndexConverter) {
            this.mappingProjectionConverter = new ProjectionConverter<F, V>(valueType, fromIndexConverter);
        }

        public final void parser(ToDocumentValueConverter<String, ? extends F> parser) {
            this.parser = new DslConverter<String, F>(String.class, parser);
        }

        public final void formatter(FromDocumentValueConverter<? super F, String> formatter) {
            this.formatter = new ProjectionConverter<F, String>(String.class, formatter);
        }

        public final void searchable(boolean searchable) {
            this.searchable = searchable;
        }

        public final void sortable(boolean sortable) {
            this.sortable = sortable;
        }

        public final void projectable(boolean projectable) {
            this.projectable = projectable;
        }

        public final void aggregable(boolean aggregable) {
            this.aggregable = aggregable;
        }

        public final void multivaluable(boolean multivaluable) {
            this.multivaluable = multivaluable;
        }

        public final void allowedHighlighterTypes(Set<SearchHighlighterType> allowedHighlighterTypes) {
            this.allowedHighlighterTypes = allowedHighlighterTypes;
        }

        public final void analyzerName(String analyzerName) {
            this.analyzerName = analyzerName;
        }

        public final void searchAnalyzerName(String searchAnalyzerName) {
            this.searchAnalyzerName = searchAnalyzerName;
        }

        public final void normalizerName(String normalizerName) {
            this.normalizerName = normalizerName;
        }

        public abstract AbstractIndexValueFieldType<SC, N, F> build();
    }
}

