/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.projection.dsl.impl;

import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.definition.impl.DefaultProjectionDefinitionContext;
import org.hibernate.search.engine.search.projection.dsl.CompositeProjectionFrom1AsStep;
import org.hibernate.search.engine.search.projection.dsl.CompositeProjectionFrom2AsStep;
import org.hibernate.search.engine.search.projection.dsl.CompositeProjectionFrom3AsStep;
import org.hibernate.search.engine.search.projection.dsl.CompositeProjectionFromAsStep;
import org.hibernate.search.engine.search.projection.dsl.CompositeProjectionInnerStep;
import org.hibernate.search.engine.search.projection.dsl.CompositeProjectionValueStep;
import org.hibernate.search.engine.search.projection.dsl.ProjectionFinalStep;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.engine.search.projection.dsl.impl.CompositeProjectionFrom1AsStepImpl;
import org.hibernate.search.engine.search.projection.dsl.impl.CompositeProjectionFrom2AsStepImpl;
import org.hibernate.search.engine.search.projection.dsl.impl.CompositeProjectionFrom3AsStepImpl;
import org.hibernate.search.engine.search.projection.dsl.impl.CompositeProjectionFromAnyNumberAsStep;
import org.hibernate.search.engine.search.projection.dsl.spi.SearchProjectionDslContext;
import org.hibernate.search.engine.search.projection.spi.CompositeProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ProjectionTypeKeys;
import org.hibernate.search.util.common.impl.Contracts;

public class CompositeProjectionInnerStepImpl<SR>
implements CompositeProjectionInnerStep {
    private final SearchProjectionDslContext<?> dslContext;
    private final SearchProjectionFactory<SR, ?, ?> projectionFactory;
    private final CompositeProjectionBuilder builder;
    private final String objectFieldPath;

    public CompositeProjectionInnerStepImpl(SearchProjectionDslContext<?> dslContext, SearchProjectionFactory<SR, ?, ?> projectionFactory) {
        this.dslContext = dslContext;
        this.projectionFactory = projectionFactory;
        this.builder = dslContext.scope().projectionBuilders().composite();
        this.objectFieldPath = null;
    }

    public CompositeProjectionInnerStepImpl(SearchProjectionDslContext<?> dslContext, SearchProjectionFactory<SR, ?, ?> projectionFactory, String objectFieldPath) {
        this.dslContext = dslContext;
        this.projectionFactory = projectionFactory;
        this.builder = dslContext.scope().fieldQueryElement(objectFieldPath, ProjectionTypeKeys.OBJECT);
        this.objectFieldPath = objectFieldPath;
    }

    @Override
    public <V> CompositeProjectionValueStep<?, V> as(Class<V> objectClass) {
        SearchProjectionFactory<SR, ?, ?> projectionFactoryWithCorrectRoot = this.objectFieldPath == null ? this.projectionFactory : this.projectionFactory.withRoot(this.objectFieldPath);
        return this.dslContext.scope().projectionRegistry().composite(objectClass).apply(projectionFactoryWithCorrectRoot, this, DefaultProjectionDefinitionContext.INSTANCE);
    }

    @Override
    public <V1> CompositeProjectionFrom1AsStep<V1> from(SearchProjection<V1> projection) {
        return new CompositeProjectionFrom1AsStepImpl<V1>(this.builder, projection);
    }

    @Override
    public <V1, V2> CompositeProjectionFrom2AsStep<V1, V2> from(SearchProjection<V1> projection1, SearchProjection<V2> projection2) {
        return new CompositeProjectionFrom2AsStepImpl<V1, V2>(this.builder, projection1, projection2);
    }

    @Override
    public <V1, V2, V3> CompositeProjectionFrom3AsStep<V1, V2, V3> from(SearchProjection<V1> projection1, SearchProjection<V2> projection2, SearchProjection<V3> projection3) {
        return new CompositeProjectionFrom3AsStepImpl<V1, V2, V3>(this.builder, projection1, projection2, projection3);
    }

    @Override
    public CompositeProjectionFromAsStep from(SearchProjection<?> ... projections) {
        Contracts.assertNotNullNorEmpty((Object[])projections, (String)"projections");
        return new CompositeProjectionFromAnyNumberAsStep(this.builder, projections);
    }

    @Override
    public final CompositeProjectionFromAsStep from(ProjectionFinalStep<?> ... dslFinalSteps) {
        Contracts.assertNotNullNorEmpty((Object[])dslFinalSteps, (String)"dslFinalSteps");
        SearchProjection[] projections = new SearchProjection[dslFinalSteps.length];
        for (int i = 0; i < dslFinalSteps.length; ++i) {
            projections[i] = dslFinalSteps[i].toProjection();
        }
        return this.from(projections);
    }
}

