/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl;

import java.util.Arrays;
import java.util.Collection;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateOptionsStep;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;

public interface RangePredicateMatchingGenericStep<T, N extends RangePredicateOptionsStep<?>> {
    default public N between(T lowerBound, T upperBound) {
        return this.within(Range.between(lowerBound, upperBound));
    }

    default public N between(T lowerBound, RangeBoundInclusion lowerBoundInclusion, T upperBound, RangeBoundInclusion upperBoundInclusion) {
        return this.within(Range.between(lowerBound, (RangeBoundInclusion)lowerBoundInclusion, upperBound, (RangeBoundInclusion)upperBoundInclusion));
    }

    default public N atLeast(T lowerBoundValue) {
        return this.within(Range.atLeast(lowerBoundValue));
    }

    default public N greaterThan(T lowerBoundValue) {
        return this.within(Range.greaterThan(lowerBoundValue));
    }

    default public N atMost(T upperBoundValue) {
        return this.within(Range.atMost(upperBoundValue));
    }

    default public N lessThan(T upperBoundValue) {
        return this.within(Range.lessThan(upperBoundValue));
    }

    public N within(Range<? extends T> var1);

    default public N withinAny(Range<?> ... ranges) {
        return this.withinAny(Arrays.asList(ranges));
    }

    default public N withinAny(Collection<? extends Range<?>> ranges) {
        return this.withinAny(ranges, ValueModel.MAPPING);
    }

    public N withinAny(Collection<? extends Range<?>> var1, ValueModel var2);
}

