/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.aggregation.dsl.impl;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.aggregation.dsl.RangeAggregationRangeMoreStep;
import org.hibernate.search.engine.search.aggregation.dsl.RangeAggregationRangeStep;
import org.hibernate.search.engine.search.aggregation.dsl.spi.SearchAggregationDslContext;
import org.hibernate.search.engine.search.aggregation.spi.RangeAggregationBuilder;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.impl.Contracts;

class RangeAggregationRangeStepImpl<SR, PDF extends SearchPredicateFactory<SR>, F>
implements RangeAggregationRangeStep<SR, RangeAggregationRangeStepImpl<SR, PDF, F>, PDF, F>,
RangeAggregationRangeMoreStep<SR, RangeAggregationRangeStepImpl<SR, PDF, F>, RangeAggregationRangeStepImpl<SR, PDF, F>, PDF, F> {
    private final RangeAggregationBuilder<F> builder;
    private final SearchAggregationDslContext<SR, ?, ? extends PDF> dslContext;

    RangeAggregationRangeStepImpl(RangeAggregationBuilder<F> builder, SearchAggregationDslContext<SR, ?, ? extends PDF> dslContext) {
        this.builder = builder;
        this.dslContext = dslContext;
    }

    @Override
    public RangeAggregationRangeStepImpl<SR, PDF, F> range(Range<? extends F> range) {
        Contracts.assertNotNull(range, (String)"range");
        this.builder.range(range);
        return this;
    }

    @Override
    public RangeAggregationRangeStepImpl<SR, PDF, F> ranges(Collection<? extends Range<? extends F>> ranges) {
        Contracts.assertNotNull(ranges, (String)"ranges");
        for (Range<F> range : ranges) {
            this.range((Range)range);
        }
        return this;
    }

    @Override
    public RangeAggregationRangeStepImpl<SR, PDF, F> filter(Function<? super PDF, ? extends PredicateFinalStep> clauseContributor) {
        SearchPredicate predicate = clauseContributor.apply(this.dslContext.predicateFactory()).toPredicate();
        return this.filter(predicate);
    }

    @Override
    public RangeAggregationRangeStepImpl<SR, PDF, F> filter(SearchPredicate searchPredicate) {
        this.builder.filter(searchPredicate);
        return this;
    }

    @Override
    public SearchAggregation<Map<Range<F>, Long>> toAggregation() {
        return this.builder.build();
    }
}

