package org.hibernate.search.engine.logging.impl;

import java.util.Locale;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import java.io.Serializable;
import java.util.Set;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.engine.search.common.RewriteMethod;
import org.hibernate.search.util.common.SearchException;
import java.util.ServiceConfigurationError;
import java.lang.String;
import org.jboss.logging.Logger;
import org.hibernate.search.engine.spatial.GeoPoint;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import java.util.List;
import java.lang.IllegalArgumentException;
import org.hibernate.search.engine.environment.bean.spi.BeanNotFoundException;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoadingException;
import java.time.Duration;
import java.lang.Exception;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.util.common.reporting.spi.EventContextProvider;
import org.hibernate.search.engine.search.projection.definition.ProjectionDefinition;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.search.engine.mapper.model.spi.MappingElement;
import java.util.Collection;
import java.lang.Throwable;
import java.lang.Class;
import java.lang.Object;
import java.util.Arrays;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;
import java.time.format.DateTimeFormatter;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void startingExecutor(final String name) {
        super.log.logf(FQCN, DEBUG, null, startingExecutor$str(), name);
    }
    protected String startingExecutor$str() {
        return "HSEARCH000230: Starting executor '%1$s'";
    }
    @Override
    public final void stoppingExecutor(final String indexName) {
        super.log.logf(FQCN, DEBUG, null, stoppingExecutor$str(), indexName);
    }
    protected String stoppingExecutor$str() {
        return "HSEARCH000231: Stopping executor '%1$s'";
    }
    protected String rangePredicateCannotMatchNullValue$str() {
        return "HSEARCH000237: Invalid range: at least one bound in range predicates must be non-null.";
    }
    @Override
    public final SearchException rangePredicateCannotMatchNullValue(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), rangePredicateCannotMatchNullValue$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String noPublicNoArgConstructor$str() {
        return "HSEARCH000242: Invalid type '%1$s': missing constructor. The type must expose a public, no-arguments constructor.";
    }
    @Override
    public final SearchException noPublicNoArgConstructor(final Class<?> clazz) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noPublicNoArgConstructor$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(clazz)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToConvertConfigurationProperty$str() {
        return "HSEARCH000501: Invalid value for configuration property '%1$s': '%2$s'. %3$s";
    }
    @Override
    public final SearchException unableToConvertConfigurationProperty(final String key, final Object rawValue, final String errorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToConvertConfigurationProperty$str(), key, rawValue, errorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPropertyValue$str() {
        return "HSEARCH000502: Invalid value: expected either an instance of '%1$s' or a String that can be parsed into that type. %2$s";
    }
    @Override
    public final SearchException invalidPropertyValue(final Class<?> expectedType, final String errorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidPropertyValue$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedType), errorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidBooleanPropertyValue$str() {
        return "HSEARCH000503: Invalid Boolean value: expected either a Boolean, the String 'true' or the String 'false'. %1$s";
    }
    @Override
    public final SearchException invalidBooleanPropertyValue(final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidBooleanPropertyValue$str(), nestedErrorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIntegerPropertyValue$str() {
        return "HSEARCH000504: Invalid Integer value: expected either a Number or a String that can be parsed into an Integer. %1$s";
    }
    @Override
    public final SearchException invalidIntegerPropertyValue(final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIntegerPropertyValue$str(), nestedErrorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidLongPropertyValue$str() {
        return "HSEARCH000505: Invalid Long value: expected either a Number or a String that can be parsed into a Long. %1$s";
    }
    @Override
    public final SearchException invalidLongPropertyValue(final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidLongPropertyValue$str(), nestedErrorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMultiPropertyValue$str() {
        return "HSEARCH000506: Invalid multi value: expected either a single value of the correct type, a Collection, or a String, and interpreting as a single value failed with the following exception. %1$s";
    }
    @Override
    public final SearchException invalidMultiPropertyValue(final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidMultiPropertyValue$str(), nestedErrorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String relativeFieldNameCannotBeNullOrEmpty$str() {
        return "HSEARCH000514: Invalid index field name '%1$s': field names cannot be null or empty.";
    }
    @Override
    public final SearchException relativeFieldNameCannotBeNullOrEmpty(final String relativeFieldName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), relativeFieldNameCannotBeNullOrEmpty$str(), relativeFieldName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String relativeFieldNameCannotContainDot$str() {
        return "HSEARCH000515: Invalid index field name '%1$s': field names cannot contain a dot ('.'). Remove the dot from your field name, or if you are declaring the field in a bridge and want a tree of fields, declare an object field using the objectField() method.";
    }
    @Override
    public final SearchException relativeFieldNameCannotContainDot(final String relativeFieldName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), relativeFieldNameCannotContainDot$str(), relativeFieldName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidGeoPolygonFirstPointNotIdenticalToLastPoint$str() {
        return "HSEARCH000516: Invalid polygon: the first point '%1$s' should be identical to the last point '%2$s' to properly close the polygon.";
    }
    @Override
    public final IllegalArgumentException invalidGeoPolygonFirstPointNotIdenticalToLastPoint(final GeoPoint firstPoint, final GeoPoint lastPoint) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidGeoPolygonFirstPointNotIdenticalToLastPoint$str(), firstPoint, lastPoint));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String collectedFailureLimitReached$str() {
        return "HSEARCH000519: Hibernate Search encountered %3$s failures during %1$s. Only the first %2$s failures are displayed here. See the TRACE logs for extra failures.";
    }
    @Override
    public final String collectedFailureLimitReached(final String process, final int failureLimit, final int failureCount) {
        return String.format(getLoggingLocale(), collectedFailureLimitReached$str(), process, failureLimit, failureCount);
    }
    protected String collectedFailures$str() {
        return "HSEARCH000520: Hibernate Search encountered failures during %1$s. Failures:\n%2$s";
    }
    @Override
    public final SearchException collectedFailures(final String process, final String renderedFailures, final Collection<Throwable> failures) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), collectedFailures$str(), process, renderedFailures));
        _copyStackTraceMinusOne(result);
        failures.forEach($failuresVar -> result.addSuppressed($failuresVar));
        return result;
    }
    @Override
    public final void newCollectedFailure(final String process, final EventContextProvider contextProvider, final Throwable failure) {
        super.log.logf(FQCN, TRACE, failure, newCollectedFailure$str(), process, new org.hibernate.search.util.common.logging.impl.EventContextFormatter(contextProvider));
    }
    protected String newCollectedFailure$str() {
        return "HSEARCH000521: Hibernate Search encountered a failure during %1$s; continuing for now to list all problems, but the process will ultimately be aborted.\n%2$s\nFailure:";
    }
    @Override
    public final void exceptionWhileCollectingFailure(final String causeMessage, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, exceptionWhileCollectingFailure$str(), causeMessage);
    }
    protected String exceptionWhileCollectingFailure$str() {
        return "HSEARCH000522: Exception while collecting a failure -- this may indicate a bug or a missing test in Hibernate Search. Please report it: https://hibernate.org/community/ Nested exception: %1$s";
    }
    protected String cannotCallDslExtensionIfSupportedAfterOrElse$str() {
        return "HSEARCH000525: Invalid call of ifSupported(...) after orElse(...). Use a separate extension() context, or move the orElse(...) call last.";
    }
    @Override
    public final SearchException cannotCallDslExtensionIfSupportedAfterOrElse() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotCallDslExtensionIfSupportedAfterOrElse$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String dslExtensionNoMatch$str() {
        return "HSEARCH000526: None of the provided extensions can be applied to the current context.  Attempted extensions: %1$s. If you want to ignore this, use .extension().ifSupported(...).orElse(ignored -> { }).";
    }
    @Override
    public final SearchException dslExtensionNoMatch(final List<?> attemptedExtensions) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), dslExtensionNoMatch$str(), attemptedExtensions));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String securityManagerLoadingError$str() {
        return "HSEARCH000528: Security manager does not allow access to the constructor of type '%1$s': %2$s";
    }
    @Override
    public final SearchException securityManagerLoadingError(final Class<?> classToLoad, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), securityManagerLoadingError$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToLoadTheClass$str() {
        return "HSEARCH000530: Unable to load class '%1$s': %2$s";
    }
    @Override
    public final ClassLoadingException unableToLoadTheClass(final String className, final String causeMessage, final Throwable cause) {
        final ClassLoadingException result = new ClassLoadingException(String.format(getLoggingLocale(), unableToLoadTheClass$str(), className, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownNameForBackend$str() {
        return "HSEARCH000533: No backend with name '%1$s'. Check that at least one entity is configured to target that backend. The following backends can be retrieved by name: %2$s. %3$s";
    }
    @Override
    public final SearchException unknownNameForBackend(final String backendName, final Collection<String> validBackendNames, final String defaultBackendMessage) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownNameForBackend$str(), backendName, validBackendNames, defaultBackendMessage));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String defaultBackendAvailable$str() {
        return "The default backend can be retrieved";
    }
    @Override
    public final String defaultBackendAvailable() {
        return String.format(getLoggingLocale(), defaultBackendAvailable$str());
    }
    protected String defaultBackendUnavailable$str() {
        return "The default backend cannot be retrieved, because no entity is mapped to that backend";
    }
    @Override
    public final String defaultBackendUnavailable() {
        return String.format(getLoggingLocale(), defaultBackendUnavailable$str());
    }
    protected String unknownNameForIndexManager$str() {
        return "HSEARCH000534: No index manager with name '%1$s'. Check that at least one entity is configured to target that index. The following indexes can be retrieved by name: %2$s.";
    }
    @Override
    public final SearchException unknownNameForIndexManager(final String indexManagerName, final Collection<String> validIndexNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownNameForIndexManager$str(), indexManagerName, validIndexNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToInstantiateClass$str() {
        return "HSEARCH000540: Unable to instantiate class '%1$s': %2$s";
    }
    @Override
    public final SearchException unableToInstantiateClass(final String className, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToInstantiateClass$str(), className, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String subtypeExpected$str() {
        return "HSEARCH000542: Invalid type '%1$s': this type cannot be assigned to type '%2$s'.";
    }
    @Override
    public final SearchException subtypeExpected(final Class<?> classToLoad, final Class<?> superType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), subtypeExpected$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad), new org.hibernate.search.util.common.logging.impl.ClassFormatter(superType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String implementationRequired$str() {
        return "HSEARCH000543: Invalid type '%1$s': this type is an interface. An implementation class is required.";
    }
    @Override
    public final SearchException implementationRequired(final Class<?> classToLoad) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), implementationRequired$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noPublicMapArgConstructor$str() {
        return "HSEARCH000544: Invalid type '%1$s': missing constructor. The type must expose a public constructor with a single parameter of type Map.";
    }
    @Override
    public final SearchException noPublicMapArgConstructor(final Class<?> classToLoad) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noPublicMapArgConstructor$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexedEmbeddedCyclicRecursion$str() {
        return "HSEARCH000546: Cyclic recursion starting from '%1$s' on %2$s. Index field path starting from that location and ending with a cycle: '%3$s'. A type cannot declare an unrestricted @IndexedEmbedded to itself, even indirectly. To break the cycle, you should consider adding filters to your @IndexedEmbedded: includePaths, includeDepth, excludePaths, ...";
    }
    @Override
    public final SearchException indexedEmbeddedCyclicRecursion(final MappingElement indexedEmbedded, final EventContext indexedEmbeddedLocation, final String cyclicRecursionPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexedEmbeddedCyclicRecursion$str(), indexedEmbedded, new org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter(indexedEmbeddedLocation), cyclicRecursionPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidBeanReferencePropertyValue$str() {
        return "HSEARCH000547: Invalid BeanReference value: expected an instance of '%1$s', BeanReference, String or Class. %2$s";
    }
    @Override
    public final SearchException invalidBeanReferencePropertyValue(final Class<?> expectedType, final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidBeanReferencePropertyValue$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedType), nestedErrorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String perFieldBoostWithConstantScore$str() {
        return "HSEARCH000551: Invalid use of per-field boost: the predicate score is constant. Cannot assign a different boost to each field when the predicate score is constant.";
    }
    @Override
    public final SearchException perFieldBoostWithConstantScore() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), perFieldBoostWithConstantScore$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPhrasePredicateSlop$str() {
        return "HSEARCH000553: Invalid slop: %1$d. The slop must be positive or zero.";
    }
    @Override
    public final SearchException invalidPhrasePredicateSlop(final int slop) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidPhrasePredicateSlop$str(), slop));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFuzzyMaximumEditDistance$str() {
        return "HSEARCH000554: Invalid maximum edit distance: %1$d. The value must be 0, 1 or 2.";
    }
    @Override
    public final SearchException invalidFuzzyMaximumEditDistance(final int maximumEditDistance) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFuzzyMaximumEditDistance$str(), maximumEditDistance));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidExactPrefixLength$str() {
        return "HSEARCH000555: Invalid exact prefix length: %1$d. The value must be positive or zero.";
    }
    @Override
    public final SearchException invalidExactPrefixLength(final int exactPrefixLength) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidExactPrefixLength$str(), exactPrefixLength));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToParseTemporal$str() {
        return "HSEARCH000557: Invalid value for type '%1$s': '%2$s'. The expected format is '%3$s'.";
    }
    @Override
    public final SearchException unableToParseTemporal(final Class<? extends java.time.temporal.TemporalAccessor> type, final String value, final DateTimeFormatter formatter, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToParseTemporal$str(), new org.hibernate.search.util.common.logging.impl.SimpleNameClassFormatter(type), value, formatter), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNumberPropertyValue$str() {
        return "HSEARCH000558: Invalid %1$s value: expected either a Number or a String that can be parsed into a %1$s. %2$s";
    }
    @Override
    public final SearchException invalidNumberPropertyValue(final Class<? extends Number> type, final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidNumberPropertyValue$str(), new org.hibernate.search.util.common.logging.impl.SimpleNameClassFormatter(type), nestedErrorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidStringForType$str() {
        return "HSEARCH000559: Invalid string for type '%2$s': '%1$s'. %3$s";
    }
    @Override
    public final SearchException invalidStringForType(final String value, final Class<?> type, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidStringForType$str(), value, new org.hibernate.search.util.common.logging.impl.ClassFormatter(type), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidStringForEnum$str() {
        return "HSEARCH000560: Invalid value for enum '%2$s': '%1$s'.";
    }
    @Override
    public final SearchException invalidStringForEnum(final String value, final Class<? extends Enum<?>> enumType, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidStringForEnum$str(), value, new org.hibernate.search.util.common.logging.impl.ClassFormatter(enumType)), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonSingleHit$str() {
        return "HSEARCH000561: Multiple hits when a single hit was expected.";
    }
    @Override
    public final SearchException nonSingleHit() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonSingleHit$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String threadInterruptedWhileSubmittingWork$str() {
        return "HSEARCH000562: Unable to submit work to '%1$s': thread received interrupt signal. The work has been discarded.";
    }
    @Override
    public final SearchException threadInterruptedWhileSubmittingWork(final String orchestratorName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), threadInterruptedWhileSubmittingWork$str(), orchestratorName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String submittedWorkToStoppedOrchestrator$str() {
        return "HSEARCH000563: Unable to submit work to '%1$s': this orchestrator is stopped. The work has been discarded.";
    }
    @Override
    public final SearchException submittedWorkToStoppedOrchestrator(final String orchestratorName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), submittedWorkToStoppedOrchestrator$str(), orchestratorName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToParseGeoPoint$str() {
        return "HSEARCH000564: Invalid geo-point value: '%1$s'. The expected format is '<latitude as double>, <longitude as double>'.";
    }
    @Override
    public final SearchException unableToParseGeoPoint(final String value) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToParseGeoPoint$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownAggregationKey$str() {
        return "HSEARCH000565: Unknown aggregation key '%1$s'. This key was not used when building the search query.";
    }
    @Override
    public final SearchException unknownAggregationKey(final AggregationKey<?> key) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownAggregationKey$str(), key));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidConfigurationPropertyCheckingStrategyName$str() {
        return "HSEARCH000566: Invalid configuration property checking strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidConfigurationPropertyCheckingStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidConfigurationPropertyCheckingStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void configurationPropertyTrackingDisabled() {
        super.log.logf(FQCN, INFO, null, configurationPropertyTrackingDisabled$str());
    }
    protected String configurationPropertyTrackingDisabled$str() {
        return "HSEARCH000567: Configuration property tracking is disabled; unused properties will not be logged.";
    }
    @Override
    public final void configurationPropertyTrackingUnusedProperties(final Set<String> propertyKeys, final String disableWarningKey, final String disableWarningValue) {
        super.log.logf(FQCN, WARN, null, configurationPropertyTrackingUnusedProperties$str(), propertyKeys, disableWarningKey, disableWarningValue);
    }
    protected String configurationPropertyTrackingUnusedProperties$str() {
        return "HSEARCH000568: Invalid configuration passed to Hibernate Search: some properties in the given configuration are not used. There might be misspelled property keys in your configuration. Unused properties: %1$s. To disable this warning, set the property '%2$s' to '%3$s'.";
    }
    @Override
    public final void failureInFailureHandler(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, failureInFailureHandler$str());
    }
    protected String failureInFailureHandler$str() {
        return "HSEARCH000569: The background failure handler threw an exception while handling a previous failure. The failure may not have been reported.";
    }
    protected String fieldTemplateNameCannotBeNullOrEmpty$str() {
        return "HSEARCH000570: Invalid index field template name '%1$s': field template names cannot be null or empty.";
    }
    @Override
    public final SearchException fieldTemplateNameCannotBeNullOrEmpty(final String templateName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), fieldTemplateNameCannotBeNullOrEmpty$str(), templateName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fieldTemplateNameCannotContainDot$str() {
        return "HSEARCH000571: Invalid index field template name '%1$s': field template names cannot contain a dot ('.').";
    }
    @Override
    public final SearchException fieldTemplateNameCannotContainDot(final String relativeFieldName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), fieldTemplateNameCannotContainDot$str(), relativeFieldName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedMultiValuedField$str() {
        return "HSEARCH000572: Inconsistent index data: a supposedly single-valued field returned multiple values. Values: [%1$s, %2$s].";
    }
    @Override
    public final SearchException unexpectedMultiValuedField(final Object value1, final Object value2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedMultiValuedField$str(), value1, value2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String obsoleteConfigurationPropertiesFromSearch5$str() {
        return "HSEARCH000573: Invalid configuration passed to Hibernate Search: some properties in the given configuration are obsolete.Configuration properties changed between Hibernate Search 5 and Hibernate Search 6 Check out the reference documentation and upgrade your configuration. Obsolete properties: %1$s.";
    }
    @Override
    public final SearchException obsoleteConfigurationPropertiesFromSearch5(final Set<String> propertyKeys) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), obsoleteConfigurationPropertiesFromSearch5$str(), propertyKeys));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDefaultBackendRegistered$str() {
        return "HSEARCH000575: No default backend. Check that at least one entity is configured to target the default backend. The following backends can be retrieved by name: %1$s.";
    }
    @Override
    public final SearchException noDefaultBackendRegistered(final Collection<String> validBackendNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noDefaultBackendRegistered$str(), validBackendNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleConfiguredBeanReferencesForType$str() {
        return "HSEARCH000576: Ambiguous bean reference to type '%1$s': multiple beans are explicitly defined for this type in Hibernate Search's internal registry. Explicitly defined beans: %2$s.";
    }
    @Override
    public final BeanNotFoundException multipleConfiguredBeanReferencesForType(final Class<?> exposedType, final List<? extends org.hibernate.search.engine.environment.bean.BeanReference<?>> references) {
        final BeanNotFoundException result = new BeanNotFoundException(String.format(getLoggingLocale(), multipleConfiguredBeanReferencesForType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(exposedType), references));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noConfiguredBeanReferenceForType$str() {
        return "HSEARCH000577: No beans defined for type '%1$s' in Hibernate Search's internal registry.";
    }
    @Override
    public final BeanNotFoundException noConfiguredBeanReferenceForType(final Class<?> exposedType) {
        final BeanNotFoundException result = new BeanNotFoundException(String.format(getLoggingLocale(), noConfiguredBeanReferenceForType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(exposedType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noConfiguredBeanReferenceForTypeAndName$str() {
        return "HSEARCH000578: No beans defined for type '%1$s' and name '%2$s' in Hibernate Search's internal registry.";
    }
    @Override
    public final BeanNotFoundException noConfiguredBeanReferenceForTypeAndName(final Class<?> exposedType, final String nameReference) {
        final BeanNotFoundException result = new BeanNotFoundException(String.format(getLoggingLocale(), noConfiguredBeanReferenceForTypeAndName$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(exposedType), nameReference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotResolveBeanReference3$str() {
        return "HSEARCH000579: Unable to resolve bean reference to type '%1$s' and name '%2$s'. %3$s";
    }
    @Override
    public final BeanNotFoundException cannotResolveBeanReference(final Class<?> typeReference, final String nameReference, final String failureMessages, final RuntimeException mainFailure, final Collection<? extends RuntimeException> otherFailures) {
        final BeanNotFoundException result = new BeanNotFoundException(String.format(getLoggingLocale(), cannotResolveBeanReference3$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(typeReference), nameReference, failureMessages), mainFailure);
        _copyStackTraceMinusOne(result);
        otherFailures.forEach($otherFailuresVar -> result.addSuppressed($otherFailuresVar));
        return result;
    }
    protected String cannotResolveBeanReference2$str() {
        return "HSEARCH000580: Unable to resolve bean reference to type '%1$s'. %2$s";
    }
    @Override
    public final BeanNotFoundException cannotResolveBeanReference(final Class<?> typeReference, final String failureMessages, final RuntimeException beanProviderFailure, final Collection<? extends RuntimeException> otherFailures) {
        final BeanNotFoundException result = new BeanNotFoundException(String.format(getLoggingLocale(), cannotResolveBeanReference2$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(typeReference), failureMessages), beanProviderFailure);
        _copyStackTraceMinusOne(result);
        otherFailures.forEach($otherFailuresVar -> result.addSuppressed($otherFailuresVar));
        return result;
    }
    protected String failedToResolveBeanUsingInternalRegistry$str() {
        return "Failed to resolve bean from Hibernate Search's internal registry with exception: %1$s";
    }
    @Override
    public final String failedToResolveBeanUsingInternalRegistry(final String exceptionMessage) {
        return String.format(getLoggingLocale(), failedToResolveBeanUsingInternalRegistry$str(), exceptionMessage);
    }
    protected String failedToResolveBeanUsingBeanManager$str() {
        return "Failed to resolve bean from bean manager with exception: %1$s";
    }
    @Override
    public final String failedToResolveBeanUsingBeanManager(final String exceptionMessage) {
        return String.format(getLoggingLocale(), failedToResolveBeanUsingBeanManager$str(), exceptionMessage);
    }
    protected String failedToResolveBeanUsingReflection$str() {
        return "Failed to resolve bean using reflection with exception: %1$s";
    }
    @Override
    public final String failedToResolveBeanUsingReflection(final String exceptionMessage) {
        return String.format(getLoggingLocale(), failedToResolveBeanUsingReflection$str(), exceptionMessage);
    }
    protected String noBackendFactoryRegistered$str() {
        return "HSEARCH000581: Unable to resolve backend type: configuration property '%1$s' is not set, and there isn't any backend in the classpath. Check that you added the desired backend to your project's dependencies.";
    }
    @Override
    public final SearchException noBackendFactoryRegistered(final String propertyKey) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noBackendFactoryRegistered$str(), propertyKey));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleBackendFactoriesRegistered$str() {
        return "HSEARCH000582: Ambiguous backend type: configuration property '%1$s' is not set, and multiple backend types are present in the classpath. Set property '%1$s' to one of the following to select the backend type: %2$s";
    }
    @Override
    public final SearchException multipleBackendFactoriesRegistered(final String propertyKey, final Collection<String> backendTypeNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multipleBackendFactoriesRegistered$str(), propertyKey, backendTypeNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidDslArgumentType$str() {
        return "HSEARCH000583: Invalid type for DSL arguments: '%1$s'. Expected '%2$s' or a subtype.";
    }
    @Override
    public final SearchException invalidDslArgumentType(final Class<?> type, final Class<?> correctType, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidDslArgumentType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(type), new org.hibernate.search.util.common.logging.impl.ClassFormatter(correctType)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidReturnType$str() {
        return "HSEARCH000584: Invalid type for returned values: '%1$s'. Expected '%2$s' or a supertype.";
    }
    @Override
    public final SearchException invalidReturnType(final Class<?> type, final Class<?> correctType, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidReturnType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(type), new org.hibernate.search.util.common.logging.impl.ClassFormatter(correctType)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String timedOut$str() {
        return "HSEARCH000586: Operation exceeded the timeout of %1$s.";
    }
    @Override
    public final SearchTimeoutException timedOut(final Duration timeout, final Exception cause) {
        final SearchTimeoutException result = new SearchTimeoutException(String.format(getLoggingLocale(), timedOut$str(), new org.hibernate.search.util.common.logging.impl.DurationInSecondsAndFractionsFormatter(timeout)), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notExactTotalHitCount$str() {
        return "HSEARCH000587: Unable to provide the exact total hit count: only a lower-bound approximation is available. This is generally the result of setting query options such as a timeout or the total hit count threshold. Either unset these options, or retrieve the lower-bound hit count approximation through '.total().hitCountLowerBound()'.";
    }
    @Override
    public final SearchException notExactTotalHitCount() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), notExactTotalHitCount$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String twoTypesTargetSameIndex$str() {
        return "HSEARCH000588: Multiple entity types mapped to index '%1$s': '%2$s', '%3$s'. Each indexed type must be mapped to its own, dedicated index.";
    }
    @Override
    public final SearchException twoTypesTargetSameIndex(final String indexName, final String mappedTypeName, final String anotherMappedTypeName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), twoTypesTargetSameIndex$str(), indexName, mappedTypeName, anotherMappedTypeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateBeanUsingReflection$str() {
        return "HSEARCH000589: Unable to create bean using reflection: %1$s";
    }
    @Override
    public final BeanNotFoundException unableToCreateBeanUsingReflection(final String causeMessage, final Exception e) {
        final BeanNotFoundException result = new BeanNotFoundException(String.format(getLoggingLocale(), unableToCreateBeanUsingReflection$str(), causeMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noConfiguredBeanManager$str() {
        return "HSEARCH000590: No configured bean manager.";
    }
    @Override
    public final BeanNotFoundException noConfiguredBeanManager() {
        final BeanNotFoundException result = new BeanNotFoundException(String.format(getLoggingLocale(), noConfiguredBeanManager$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToResolveToClassName$str() {
        return "HSEARCH000591: Unable to resolve '%2$s' to a class extending '%1$s': %3$s";
    }
    @Override
    public final BeanNotFoundException unableToResolveToClassName(final Class<?> typReference, final String nameReference, final String causeMessage, final Exception e) {
        final BeanNotFoundException result = new BeanNotFoundException(String.format(getLoggingLocale(), unableToResolveToClassName$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(typReference), nameReference, causeMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidBeanRetrieval$str() {
        return "HSEARCH000592: Invalid bean reference: '%1$s'. The reference is prefixed with '%2$s', which is not a valid bean retrieval prefix. If you want to reference a bean by name, and the name contains a colon, use 'bean:%1$s'. Otherwise, use a valid bean retrieval prefix among the following: %3$s.";
    }
    @Override
    public final BeanNotFoundException invalidBeanRetrieval(final String beanReference, final String invalidPrefix, final List<String> validPrefixes, final Exception e) {
        final BeanNotFoundException result = new BeanNotFoundException(String.format(getLoggingLocale(), invalidBeanRetrieval$str(), beanReference, invalidPrefix, validPrefixes), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String relativeNamedPredicateNameCannotBeNullOrEmpty$str() {
        return "HSEARCH000593: Named predicate name '%1$s' is invalid: field names cannot be null or empty.";
    }
    @Override
    public final SearchException relativeNamedPredicateNameCannotBeNullOrEmpty(final String relativeNamedPredicateName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), relativeNamedPredicateNameCannotBeNullOrEmpty$str(), relativeNamedPredicateName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String relativeNamedPredicateNameCannotContainDot$str() {
        return "HSEARCH000594: Named predicate name '%1$s' is invalid: field names cannot contain a dot ('.'). Remove the dot from your named predicate name.";
    }
    @Override
    public final SearchException relativeNamedPredicateNameCannotContainDot(final String relativeNamedPredicateName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), relativeNamedPredicateNameCannotContainDot$str(), relativeNamedPredicateName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentMultiTenancyNamedBackend$str() {
        return "HSEARCH000596: Different mappings trying to define two backends with the same name '%1$s' but having different expectations on multi-tenancy.";
    }
    @Override
    public final SearchException differentMultiTenancyNamedBackend(final String backendName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), differentMultiTenancyNamedBackend$str(), backendName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentMultiTenancyDefaultBackend$str() {
        return "HSEARCH000597: Different mappings trying to define default backends having different expectations on multi-tenancy.";
    }
    @Override
    public final SearchException differentMultiTenancyDefaultBackend() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), differentMultiTenancyDefaultBackend$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexNodeTypeNotComposite$str() {
        return "HSEARCH000598: Invalid type: %1$s is not composite.";
    }
    @Override
    public final SearchException invalidIndexNodeTypeNotComposite(final EventContext elementContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexNodeTypeNotComposite$str(), new org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter(elementContext)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexNodeTypeNotObjectField$str() {
        return "HSEARCH000599: Invalid type: %1$s is not an object field.";
    }
    @Override
    public final SearchException invalidIndexNodeTypeNotObjectField(final EventContext elementContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexNodeTypeNotObjectField$str(), new org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter(elementContext)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexNodeTypeNotValueField$str() {
        return "HSEARCH000600: Invalid type: %1$s is not a value field.";
    }
    @Override
    public final SearchException invalidIndexNodeTypeNotValueField(final EventContext elementContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexNodeTypeNotValueField$str(), new org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter(elementContext)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String inconsistentConfigurationInContextForSearch$str() {
        return "HSEARCH000601: Inconsistent configuration for %1$s in a search query across multiple indexes: %2$s";
    }
    @Override
    public final SearchException inconsistentConfigurationInContextForSearch(final EventContext elementContext, final String causeMessage, final EventContext elementContextAsParam, final SearchException cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), inconsistentConfigurationInContextForSearch$str(), new org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter(elementContext), causeMessage), cause, elementContextAsParam);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String inconsistentSupportForQueryElement$str() {
        return "HSEARCH000602: Inconsistent support for '%1$s': %2$s";
    }
    @Override
    public final SearchException inconsistentSupportForQueryElement(final SearchQueryElementTypeKey<?> key, final String causeMessage, final SearchException cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), inconsistentSupportForQueryElement$str(), key, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentAttribute$str() {
        return "HSEARCH000603: Attribute '%1$s' differs: '%2$s' vs. '%3$s'.";
    }
    @Override
    public final SearchException differentAttribute(final String attributeName, final Object component1, final Object component2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), differentAttribute$str(), attributeName, component1, component2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseQueryElementForIndexNode$str() {
        return "HSEARCH000604: Cannot use '%2$s' on %1$s: %3$s";
    }
    @Override
    public final SearchException cannotUseQueryElementForIndexNode(final EventContext elementContext, final SearchQueryElementTypeKey<?> key, final String hint, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseQueryElementForIndexNode$str(), new org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter(elementContext), key, hint), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingSupportHintForValueField$str() {
        return "Make sure the field is marked as searchable/sortable/projectable/aggregable/highlightable (whichever is relevant). If it already is, then '%1$s' is not available for fields of this type.";
    }
    @Override
    public final String missingSupportHintForValueField(final SearchQueryElementTypeKey<?> key) {
        return String.format(getLoggingLocale(), missingSupportHintForValueField$str(), key);
    }
    protected String missingSupportHintForCompositeNode$str() {
        return "Some object field features require a nested structure; try setting the field structure to 'NESTED' and reindexing all your data. If you are trying to use another feature, it probably isn't available for this field.";
    }
    @Override
    public final String missingSupportHintForCompositeNode() {
        return String.format(getLoggingLocale(), missingSupportHintForCompositeNode$str());
    }
    protected String partialSupportForQueryElement$str() {
        return "HSEARCH000606: '%1$s' can be used in some of the targeted indexes, but not all of them. %2$s";
    }
    @Override
    public final SearchException partialSupportForQueryElement(final SearchQueryElementTypeKey<?> key, final String hint) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), partialSupportForQueryElement$str(), key, hint));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String partialSupportHintForValueField$str() {
        return "Make sure the field is marked as searchable/sortable/projectable/aggregable/highlightable (whichever is relevant) in all indexes, and that the field has the same type in all indexes.";
    }
    @Override
    public final String partialSupportHintForValueField() {
        return String.format(getLoggingLocale(), partialSupportHintForValueField$str());
    }
    protected String partialSupportHintForCompositeNode$str() {
        return "If you are trying to use the 'nested' predicate, set the field structure is to 'NESTED' in all indexes, then reindex all your data.";
    }
    @Override
    public final String partialSupportHintForCompositeNode() {
        return String.format(getLoggingLocale(), partialSupportHintForCompositeNode$str());
    }
    protected String conflictingFieldModel$str() {
        return "HSEARCH000609: This field is a value field in some indexes, but an object field in other indexes.";
    }
    @Override
    public final SearchException conflictingFieldModel() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingFieldModel$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownFieldForSearch$str() {
        return "HSEARCH000610: Unknown field '%1$s'.";
    }
    @Override
    public final SearchException unknownFieldForSearch(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownFieldForSearch$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String targetFieldsSpanningMultipleNestedPaths$str() {
        return "HSEARCH000611: Invalid target fields: fields [%1$s, %3$s] are in different nested documents (%2$s vs. %4$s). All target fields must be in the same document.";
    }
    @Override
    public final SearchException targetFieldsSpanningMultipleNestedPaths(final String fieldPath1, final EventContext nestedPath1, final String fieldPath2, final EventContext nestedPath2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), targetFieldsSpanningMultipleNestedPaths$str(), fieldPath1, new org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter(nestedPath1), fieldPath2, new org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter(nestedPath2)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCloseSavedValue$str() {
        return "HSEARCH000612: Unable to close saved value for key %1$s: %2$s";
    }
    @Override
    public final SearchException unableToCloseSavedValue(final String keyName, final String message, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCloseSavedValue$str(), keyName, message), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noIntegrationBecauseInitializationNotComplete$str() {
        return "HSEARCH000613: Unable to access the Search integration: initialization hasn't completed yet.";
    }
    @Override
    public final SearchException noIntegrationBecauseInitializationNotComplete() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noIntegrationBecauseInitializationNotComplete$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotCreateEntityProjection$str() {
        return "HSEARCH000614: Cannot project on entity type '%1$s': this type cannot be loaded from an external datasource, and the documents from the index cannot be projected to its Java class '%2$s'. %3$s";
    }
    @Override
    public final SearchException cannotCreateEntityProjection(final String name, final Class<?> javaClass, final String hint) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotCreateEntityProjection$str(), name, new org.hibernate.search.util.common.logging.impl.ClassFormatter(javaClass), hint));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToResolveField$str() {
        return "HSEARCH000615: Unable to resolve field '%1$s': %2$s";
    }
    @Override
    public final SearchException unableToResolveField(final String absolutePath, final String causeMessage, final SearchException e, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToResolveField$str(), absolutePath, causeMessage), e, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void ignoringServiceConfigurationError(final Class<?> serviceContract, final ServiceConfigurationError error) {
        super.log.logf(FQCN, DEBUG, error, ignoringServiceConfigurationError$str(), serviceContract);
    }
    protected String ignoringServiceConfigurationError$str() {
        return "HSEARCH000616: Ignoring ServiceConfigurationError caught while trying to instantiate service '%s'.";
    }
    protected String paramNotDefined$str() {
        return "HSEARCH000617: Parameter with name '%1$s' was not defined on projection definition '%2$s'.";
    }
    @Override
    public final SearchException paramNotDefined(final String paramName, final ProjectionDefinition<?> definition) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), paramNotDefined$str(), paramName, definition));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTypeForEntityProjection$str() {
        return "HSEARCH000618: Invalid type for entity projection on type '%1$s': the entity type's Java class '%2$s' does not extend the requested projection type '%3$s'.";
    }
    @Override
    public final SearchException invalidTypeForEntityProjection(final String name, final Class<?> entityType, final Class<?> requestedEntityType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidTypeForEntityProjection$str(), name, new org.hibernate.search.util.common.logging.impl.ClassFormatter(entityType), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedEntityType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotIncludeAndExcludePathsWithinSameFilter$str() {
        return "HSEARCH000619: 'includePaths' and 'excludePaths' cannot be used together in the same filter. Use either `includePaths` or `excludePaths` leaving the other one empty. Included paths are: '%1$s', excluded paths are: '%2$s'.";
    }
    @Override
    public final SearchException cannotIncludeAndExcludePathsWithinSameFilter(final Set<String> includePaths, final Set<String> excludePaths) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotIncludeAndExcludePathsWithinSameFilter$str(), includePaths, excludePaths));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void multipleConfigurationProvidersAvailable(final String scope, final List<org.hibernate.search.engine.cfg.spi.ConfigurationProvider> configurationProviders) {
        super.log.logf(FQCN, DEBUG, null, multipleConfigurationProvidersAvailable$str(), scope, configurationProviders);
    }
    protected String multipleConfigurationProvidersAvailable$str() {
        return "HSEARCH000620: Multiple configuration providers are available for scope '%1$s'. They will be taken under consideration in the following order: '%2$s'.";
    }
    protected String parameterizedRewriteMethodWithoutParameter$str() {
        return "HSEARCH000621: Cannot use rewrite method '%1$s': this method requires parameter 'n', which was not specified. Use another version of the rewrite(...) method that accepts parameter 'n'.";
    }
    @Override
    public final SearchException parameterizedRewriteMethodWithoutParameter(final RewriteMethod rewriteMethod) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), parameterizedRewriteMethodWithoutParameter$str(), rewriteMethod));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonParameterizedRewriteMethodWithParameter$str() {
        return "HSEARCH000622: Cannot use rewrite method '%1$s': this method does not accept parameter 'n', but it was specified. Use another version of the rewrite(...) method that does not accept parameter 'n'.";
    }
    @Override
    public final SearchException nonParameterizedRewriteMethodWithParameter(final RewriteMethod rewriteMethod) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonParameterizedRewriteMethodWithParameter$str(), rewriteMethod));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFindQueryParameter$str() {
        return "HSEARCH000624: Query parameter '%1$s' is not set. Use `.param(..)` methods on the query to set any parameters that the query requires.";
    }
    @Override
    public final SearchException cannotFindQueryParameter(final String parameter) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFindQueryParameter$str(), parameter));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedQueryParameterType$str() {
        return "HSEARCH000625: Expecting value of query parameter '%1$s' to be of type %2$s, but instead got a value of type %3$s.";
    }
    @Override
    public final SearchException unexpectedQueryParameterType(final String name, final Class<?> expected, final Class<?> actual) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedQueryParameterType$str(), name, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expected), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actual)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String namedValuesParameterNotDefined$str() {
        return "HSEARCH000626: Named value '%1$s' has not been defined.";
    }
    @Override
    public final SearchException namedValuesParameterNotDefined(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), namedValuesParameterNotDefined$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String namedValuesParameterIncorrectType$str() {
        return "HSEARCH000627: Expecting value of named value '%1$s' to be of type %2$s, but instead got a value of type %3$s.";
    }
    @Override
    public final SearchException namedValuesParameterIncorrectType(final String name, final Class<?> expected, final Class<?> actual) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), namedValuesParameterIncorrectType$str(), name, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expected), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actual)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String securityManagerInvocationProblem$str() {
        return "HSEARCH000628: Unable to get a thread group from the SecurityManager: %1$s";
    }
    @Override
    public final SearchException securityManagerInvocationProblem(final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), securityManagerInvocationProblem$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
