/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.common.spi;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.common.spi.SearchIndexNodeTypeContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexScope;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;
import org.hibernate.search.util.common.annotation.Incubating;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public interface SearchIndexValueFieldTypeContext<SC extends SearchIndexScope<?>, N, F>
extends SearchIndexNodeTypeContext<SC, N> {
    public Class<F> valueClass();

    public DslConverter<?, F> dslConverter();

    @Incubating
    public DslConverter<?, F> parser();

    public DslConverter<F, F> rawDslConverter();

    default public DslConverter<?, F> dslConverter(ValueConvert convert) {
        switch (convert) {
            case NO: {
                return this.rawDslConverter();
            }
            case PARSE: {
                return this.parser();
            }
        }
        return this.dslConverter();
    }

    public ProjectionConverter<F, ?> projectionConverter();

    public ProjectionConverter<F, F> rawProjectionConverter();

    default public ProjectionConverter<F, ?> projectionConverter(ValueConvert convert) {
        switch (convert) {
            case NO: {
                return this.rawProjectionConverter();
            }
            case PARSE: {
                throw ((Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup())).parseConverterNotAllowed(ValueConvert.class.getSimpleName(), ValueConvert.PARSE, List.of(ValueConvert.YES, ValueConvert.NO));
            }
        }
        return this.projectionConverter();
    }

    public boolean highlighterTypeSupported(SearchHighlighterType var1);
}

