/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.tree.impl;

import java.util.Optional;
import java.util.function.BiFunction;
import org.hibernate.search.engine.common.tree.TreeFilterDefinition;
import org.hibernate.search.engine.common.tree.impl.TreeFilter;
import org.hibernate.search.engine.common.tree.spi.TreeFilterPathTracker;
import org.hibernate.search.engine.common.tree.spi.TreeNestingContext;
import org.hibernate.search.engine.common.tree.spi.TreeNodeInclusion;
import org.hibernate.search.engine.mapper.model.spi.MappingElement;
import org.hibernate.search.util.common.SearchException;

public final class ConfiguredTreeNestingContext
implements TreeNestingContext {
    public static final ConfiguredTreeNestingContext ROOT = new ConfiguredTreeNestingContext(TreeFilter.root(), "", "");
    private final TreeFilter filter;
    private final String prefixFromFilter;
    private final String unconsumedPrefix;

    private ConfiguredTreeNestingContext(TreeFilter filter, String prefixFromFilter, String unconsumedPrefix) {
        this.filter = filter;
        this.prefixFromFilter = prefixFromFilter;
        this.unconsumedPrefix = unconsumedPrefix;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "filter=" + this.filter + ",prefixFromFilter=" + this.prefixFromFilter + ",unconsumedPrefix=" + this.unconsumedPrefix + "]";
    }

    @Override
    public <T> T nest(String relativeName, TreeNestingContext.LeafFactory<T> factory) {
        String nameRelativeToFilter = this.prefixFromFilter + relativeName;
        String prefixedRelativeName = this.unconsumedPrefix + relativeName;
        boolean included = this.filter.isPathIncluded(nameRelativeToFilter);
        return factory.create(prefixedRelativeName, included ? TreeNodeInclusion.INCLUDED : TreeNodeInclusion.EXCLUDED);
    }

    @Override
    public <T> T nest(String relativeName, TreeNestingContext.CompositeFactory<T> factory) {
        String nameRelativeToFilter = this.prefixFromFilter + relativeName;
        String prefixedRelativeName = this.unconsumedPrefix + relativeName;
        boolean included = this.filter.isPathIncluded(nameRelativeToFilter);
        if (included) {
            ConfiguredTreeNestingContext nestedFilter = new ConfiguredTreeNestingContext(this.filter, nameRelativeToFilter + ".", "");
            return factory.create(prefixedRelativeName, TreeNodeInclusion.INCLUDED, nestedFilter);
        }
        return factory.create(prefixedRelativeName, TreeNodeInclusion.EXCLUDED, TreeNestingContext.excludeAll());
    }

    @Override
    public <T> T nestUnfiltered(TreeNestingContext.UnfilteredFactory<T> factory) {
        return factory.create(TreeNodeInclusion.INCLUDED, this.unconsumedPrefix);
    }

    @Override
    public <T> Optional<T> nestComposed(MappingElement mappingElement, String relativePrefix, TreeFilterDefinition definition, TreeFilterPathTracker pathTracker, TreeNestingContext.NestedContextBuilder<T> contextBuilder, BiFunction<MappingElement, String, SearchException> cyclicRecursionExceptionFactory) {
        TreeFilter composedFilter = this.filter.compose(mappingElement, relativePrefix, definition, pathTracker, cyclicRecursionExceptionFactory);
        if (!composedFilter.isEveryPathExcluded()) {
            String prefixToParse = this.unconsumedPrefix + relativePrefix;
            int afterPreviousDotIndex = 0;
            int nextDotIndex = prefixToParse.indexOf(46, afterPreviousDotIndex);
            while (nextDotIndex >= 0) {
                String objectNameRelativeToFilter = prefixToParse.substring(this.unconsumedPrefix.length(), nextDotIndex);
                if (!this.filter.isPathIncluded(objectNameRelativeToFilter)) {
                    return Optional.empty();
                }
                String objectName = prefixToParse.substring(afterPreviousDotIndex, nextDotIndex);
                contextBuilder.appendObject(objectName);
                afterPreviousDotIndex = nextDotIndex + 1;
                nextDotIndex = prefixToParse.indexOf(46, afterPreviousDotIndex);
            }
            String composedUnconsumedPrefix = prefixToParse.substring(afterPreviousDotIndex);
            ConfiguredTreeNestingContext nestedContext = new ConfiguredTreeNestingContext(composedFilter, "", composedUnconsumedPrefix);
            return Optional.of(contextBuilder.build(nestedContext));
        }
        return Optional.empty();
    }
}

