/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.hibernate.search.engine.environment.bean.BeanHolder;

final class CloseableBeanHolder<T extends Closeable>
implements BeanHolder<T> {
    private final T instance;

    CloseableBeanHolder(T instance) {
        this.instance = instance;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[instance=" + this.instance + "]";
    }

    @Override
    public T get() {
        return this.instance;
    }

    @Override
    public void close() {
        try {
            this.instance.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }
}

