/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean;

import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import org.hibernate.search.engine.environment.bean.CloseableBeanHolder;
import org.hibernate.search.engine.environment.bean.CompositeBeanHolder;
import org.hibernate.search.engine.environment.bean.DependencyClosingBeanHolder;
import org.hibernate.search.engine.environment.bean.SimpleBeanHolder;

public interface BeanHolder<T>
extends AutoCloseable {
    public T get();

    @Override
    public void close();

    default public BeanHolder<T> withDependencyAutoClosing(BeanHolder<?> ... dependencies) {
        return new DependencyClosingBeanHolder(this, Arrays.asList(dependencies));
    }

    public static <T> BeanHolder<T> of(T instance) {
        return new SimpleBeanHolder<T>(instance);
    }

    public static <T extends Closeable> BeanHolder<T> ofCloseable(T instance) {
        return new CloseableBeanHolder<T>(instance);
    }

    public static <T> BeanHolder<List<T>> of(List<? extends BeanHolder<? extends T>> beanHolders) {
        return new CompositeBeanHolder(beanHolders);
    }
}

