/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexRootBuilder;
import org.hibernate.search.engine.backend.index.spi.IndexManagerBuilder;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.mapping.spi.BackendMapperContext;
import org.hibernate.search.engine.backend.spi.BackendBuildContext;
import org.hibernate.search.engine.backend.spi.BackendFactory;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.impl.ConfigurationPropertySourceExtractor;
import org.hibernate.search.engine.cfg.impl.EngineConfigurationUtils;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.common.impl.BackendBuildContextImpl;
import org.hibernate.search.engine.common.impl.BackendNonStartedState;
import org.hibernate.search.engine.common.impl.IndexManagerNonStartedState;
import org.hibernate.search.engine.common.impl.RootBuildContext;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.mapper.mapping.building.impl.IndexManagerBuildingState;
import org.hibernate.search.engine.mapper.mapping.building.spi.BackendsInfo;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.tenancy.spi.TenancyMode;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class IndexManagerBuildingStateHolder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final OptionalConfigurationProperty<BeanReference<? extends BackendFactory>> BACKEND_TYPE = ConfigurationProperty.forKey("type").asBeanReference(BackendFactory.class).build();
    private final BeanResolver beanResolver;
    private final ConfigurationPropertySource propertySource;
    private final RootBuildContext rootBuildContext;
    private final Map<String, BackendInitialBuildState> backendBuildStateByName = new LinkedHashMap<String, BackendInitialBuildState>();
    private final Map<String, IndexManagerInitialBuildState> indexManagerBuildStateByName = new LinkedHashMap<String, IndexManagerInitialBuildState>();

    IndexManagerBuildingStateHolder(BeanResolver beanResolver, ConfigurationPropertySource propertySource, RootBuildContext rootBuildContext) {
        this.beanResolver = beanResolver;
        this.propertySource = propertySource;
        this.rootBuildContext = rootBuildContext;
    }

    void createBackends(BackendsInfo backendsInfo) {
        for (BackendsInfo.BackendInfo backendInfo : backendsInfo.values()) {
            BackendInitialBuildState backendBuildState;
            Optional<String> backendNameOptional = backendInfo.name();
            String backendName = backendNameOptional.orElse(null);
            EventContext eventContext = EventContexts.fromBackendName(backendName);
            try {
                backendBuildState = this.createBackend(backendNameOptional, backendInfo.tenancyStrategy(), eventContext);
            }
            catch (RuntimeException e) {
                this.rootBuildContext.getFailureCollector().withContext(eventContext).add(e);
                continue;
            }
            this.backendBuildStateByName.put(backendName, backendBuildState);
        }
    }

    IndexManagerBuildingState getIndexManagerBuildingState(BackendMapperContext backendMapperContext, Optional<String> backendName, String indexName, String mappedTypeName) {
        return this.getBackend(backendName.orElse(null)).createIndexManagerBuildingState(backendMapperContext, indexName, mappedTypeName);
    }

    private BackendInitialBuildState getBackend(String backendName) {
        BackendInitialBuildState backendBuildState = this.backendBuildStateByName.get(backendName);
        if (backendBuildState == null) {
            throw new AssertionFailure("Mapper asking for a reference to backend '" + backendName + "', which was not declared in advance.");
        }
        return backendBuildState;
    }

    Map<String, BackendNonStartedState> getBackendNonStartedStates() {
        LinkedHashMap<String, BackendNonStartedState> backendsByName = new LinkedHashMap<String, BackendNonStartedState>();
        for (Map.Entry<String, BackendInitialBuildState> entry : this.backendBuildStateByName.entrySet()) {
            backendsByName.put(entry.getKey(), entry.getValue().getNonStartedState());
        }
        return backendsByName;
    }

    Map<String, IndexManagerNonStartedState> getIndexManagersNonStartedStates() {
        LinkedHashMap<String, IndexManagerNonStartedState> indexManagersByName = new LinkedHashMap<String, IndexManagerNonStartedState>();
        for (Map.Entry<String, IndexManagerInitialBuildState> entry : this.indexManagerBuildStateByName.entrySet()) {
            indexManagersByName.put(entry.getKey(), entry.getValue().getNonStartedState());
        }
        return indexManagersByName;
    }

    void closeOnFailure(SuppressingCloser closer) {
        closer.pushAll(state -> state.closeOnFailure(closer), this.indexManagerBuildStateByName.values());
        closer.pushAll(BackendInitialBuildState::closeOnFailure, this.backendBuildStateByName.values());
    }

    private BackendInitialBuildState createBackend(Optional<String> backendNameOptional, TenancyMode tenancyMode, EventContext eventContext) {
        ConfigurationPropertySourceExtractor backendPropertySourceExtractor = EngineConfigurationUtils.extractorForBackend(backendNameOptional);
        ConfigurationPropertySource backendPropertySource = backendPropertySourceExtractor.extract(this.propertySource);
        try (BeanHolder backendFactoryHolder = BACKEND_TYPE.getAndMap(backendPropertySource, this.beanResolver::resolve).orElseGet(() -> this.createDefaultBackendFactory(backendPropertySource));){
            BackendBuildContextImpl backendBuildContext = new BackendBuildContextImpl(this.rootBuildContext, tenancyMode);
            BackendImplementor backend = ((BackendFactory)backendFactoryHolder.get()).create(eventContext, backendBuildContext, backendPropertySource);
            BackendInitialBuildState backendInitialBuildState = new BackendInitialBuildState(eventContext, backendPropertySourceExtractor, backendBuildContext, backend);
            return backendInitialBuildState;
        }
    }

    private BeanHolder<? extends BackendFactory> createDefaultBackendFactory(ConfigurationPropertySource backendPropertySource) {
        Map<String, BeanReference<BackendFactory>> referencesByName = this.beanResolver.namedConfiguredForRole(BackendFactory.class);
        if (referencesByName.isEmpty()) {
            throw log.noBackendFactoryRegistered(BACKEND_TYPE.resolveOrRaw(backendPropertySource));
        }
        if (referencesByName.size() > 1) {
            throw log.multipleBackendFactoriesRegistered(BACKEND_TYPE.resolveOrRaw(backendPropertySource), referencesByName.keySet());
        }
        return referencesByName.values().iterator().next().resolve(this.beanResolver);
    }

    class BackendInitialBuildState {
        private final EventContext eventContext;
        private final ConfigurationPropertySourceExtractor propertySourceExtractor;
        private final BackendBuildContext backendBuildContext;
        private final BackendImplementor backend;

        private BackendInitialBuildState(EventContext eventContext, ConfigurationPropertySourceExtractor propertySourceExtractor, BackendBuildContext backendBuildContext, BackendImplementor backend) {
            this.eventContext = eventContext;
            this.propertySourceExtractor = propertySourceExtractor;
            this.backendBuildContext = backendBuildContext;
            this.backend = backend;
        }

        IndexManagerInitialBuildState createIndexManagerBuildingState(BackendMapperContext backendMapperContext, String indexName, String mappedTypeName) {
            IndexManagerInitialBuildState state = (IndexManagerInitialBuildState)IndexManagerBuildingStateHolder.this.indexManagerBuildStateByName.get(indexName);
            if (state != null) {
                throw log.twoTypesTargetSameIndex(indexName, state.mappedTypeName, mappedTypeName);
            }
            ConfigurationPropertySourceExtractor indexPropertySourceExtractor = EngineConfigurationUtils.extractorForIndex(this.propertySourceExtractor, indexName);
            ConfigurationPropertySource indexPropertySource = indexPropertySourceExtractor.extract(IndexManagerBuildingStateHolder.this.propertySource);
            IndexManagerBuilder builder = this.backend.createIndexManagerBuilder(indexName, mappedTypeName, this.backendBuildContext, backendMapperContext, indexPropertySource);
            IndexRootBuilder schemaRootNodeBuilder = builder.schemaRootNodeBuilder();
            state = new IndexManagerInitialBuildState(indexName, mappedTypeName, indexPropertySourceExtractor, builder, schemaRootNodeBuilder);
            IndexManagerBuildingStateHolder.this.indexManagerBuildStateByName.put(indexName, state);
            return state;
        }

        void closeOnFailure() {
            this.backend.stop();
        }

        BackendNonStartedState getNonStartedState() {
            return new BackendNonStartedState(this.eventContext, this.propertySourceExtractor, this.backend);
        }
    }

    private static class IndexManagerInitialBuildState
    implements IndexManagerBuildingState {
        private final String indexName;
        private final String mappedTypeName;
        private final ConfigurationPropertySourceExtractor propertySourceExtractor;
        private final IndexManagerBuilder builder;
        private final IndexRootBuilder schemaRootNodeBuilder;
        private IndexManagerImplementor indexManager;

        IndexManagerInitialBuildState(String indexName, String mappedTypeName, ConfigurationPropertySourceExtractor propertySourceExtractor, IndexManagerBuilder builder, IndexRootBuilder schemaRootNodeBuilder) {
            this.indexName = indexName;
            this.mappedTypeName = mappedTypeName;
            this.propertySourceExtractor = propertySourceExtractor;
            this.builder = builder;
            this.schemaRootNodeBuilder = schemaRootNodeBuilder;
        }

        void closeOnFailure(SuppressingCloser closer) {
            if (this.indexManager != null) {
                closer.push(IndexManagerImplementor::stop, (Object)this.indexManager);
            } else {
                closer.push(IndexManagerBuilder::closeOnFailure, (Object)this.builder);
            }
        }

        @Override
        public IndexRootBuilder getSchemaRootNodeBuilder() {
            return this.schemaRootNodeBuilder;
        }

        @Override
        public IndexManagerImplementor build() {
            if (this.indexManager != null) {
                throw new AssertionFailure("Trying to build index manager " + this.indexName + " twice.");
            }
            this.indexManager = this.builder.build();
            return this.indexManager;
        }

        IndexManagerNonStartedState getNonStartedState() {
            if (this.indexManager == null) {
                throw new AssertionFailure("Index manager " + this.indexName + " was not built by the mapper as expected.");
            }
            return new IndexManagerNonStartedState(EventContexts.fromIndexName(this.indexName), this.propertySourceExtractor, this.indexManager);
        }
    }
}

