/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.work.execution;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import org.hibernate.search.engine.common.execution.spi.SimpleScheduledExecutor;
import org.hibernate.search.util.common.annotation.Incubating;

@Incubating
public abstract class OperationSubmitter {
    private static final OperationSubmitter BLOCKING = new BlockingOperationSubmitter();
    private static final OperationSubmitter REJECTED_EXECUTION_EXCEPTION = new RejectedExecutionExceptionOperationSubmitter();

    private OperationSubmitter() {
    }

    public abstract <T> void submitToQueue(BlockingQueue<? super T> var1, T var2, Consumer<? super T> var3) throws InterruptedException;

    public abstract <T extends Runnable> void submitToExecutor(SimpleScheduledExecutor var1, T var2, Consumer<? super T> var3) throws InterruptedException;

    public static OperationSubmitter blocking() {
        return BLOCKING;
    }

    public static OperationSubmitter rejecting() {
        return REJECTED_EXECUTION_EXCEPTION;
    }

    public static OperationSubmitter offloading(Consumer<Runnable> executor) {
        return new OffloadingExecutorOperationSubmitter(executor);
    }

    private static final class OffloadingExecutorOperationSubmitter
    extends OperationSubmitter {
        private final Consumer<Runnable> executor;

        private OffloadingExecutorOperationSubmitter(Consumer<Runnable> executor) {
            this.executor = executor;
        }

        @Override
        public <T> void submitToQueue(BlockingQueue<? super T> queue, T element, Consumer<? super T> blockingRetryProducer) {
            if (!queue.offer(element)) {
                this.executor.accept(() -> blockingRetryProducer.accept((Object)element));
            }
        }

        @Override
        public <T extends Runnable> void submitToExecutor(SimpleScheduledExecutor executor, T element, Consumer<? super T> blockingRetryProducer) {
            try {
                executor.offer(element);
            }
            catch (RejectedExecutionException e) {
                this.executor.accept(() -> blockingRetryProducer.accept((Object)element));
            }
        }
    }

    private static final class BlockingOperationSubmitter
    extends OperationSubmitter {
        private BlockingOperationSubmitter() {
        }

        @Override
        public <T> void submitToQueue(BlockingQueue<? super T> queue, T element, Consumer<? super T> blockingRetryProducer) throws InterruptedException {
            queue.put(element);
        }

        @Override
        public <T extends Runnable> void submitToExecutor(SimpleScheduledExecutor executor, T element, Consumer<? super T> blockingRetryProducer) {
            executor.submit(element);
        }
    }

    private static final class RejectedExecutionExceptionOperationSubmitter
    extends OperationSubmitter {
        private RejectedExecutionExceptionOperationSubmitter() {
        }

        @Override
        public <T> void submitToQueue(BlockingQueue<? super T> queue, T element, Consumer<? super T> blockingRetryProducer) {
            if (!queue.offer(element)) {
                throw new RejectedExecutionException();
            }
        }

        @Override
        public <T extends Runnable> void submitToExecutor(SimpleScheduledExecutor executor, T element, Consumer<? super T> blockingRetryProducer) {
            executor.offer(element);
        }
    }
}

