/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.common.spi;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.spi.SearchIndexCompositeNodeContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexNodeContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexScope;
import org.hibernate.search.engine.search.common.spi.SearchIndexValueFieldContext;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementFactory;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public abstract class SearchIndexSchemaElementContextHelper {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    public static final SearchIndexSchemaElementContextHelper VALUE_FIELD = new SearchIndexSchemaElementContextHelper(){

        @Override
        protected String missingSupportHint(SearchQueryElementTypeKey<?> key) {
            return log.missingSupportHintForValueField(key);
        }

        @Override
        public String partialSupportHint() {
            return log.partialSupportHintForValueField();
        }
    };
    public static final SearchIndexSchemaElementContextHelper COMPOSITE = new SearchIndexSchemaElementContextHelper(){

        @Override
        protected String missingSupportHint(SearchQueryElementTypeKey<?> key) {
            return log.missingSupportHintForCompositeNode();
        }

        @Override
        public String partialSupportHint() {
            return log.partialSupportHintForCompositeNode();
        }
    };

    public static <T extends SearchIndexCompositeNodeContext<?>> T throwingToComposite(SearchIndexNodeContext<?> element) {
        throw log.invalidIndexNodeTypeNotComposite(element.relativeEventContext());
    }

    public static <T extends SearchIndexCompositeNodeContext<?>> T throwingToObjectField(SearchIndexNodeContext<?> element) {
        throw log.invalidIndexNodeTypeNotObjectField(element.relativeEventContext());
    }

    public static <T extends SearchIndexValueFieldContext<?>> T throwingToValueField(SearchIndexNodeContext<?> element) {
        throw log.invalidIndexNodeTypeNotValueField(element.relativeEventContext());
    }

    public static void checkNestedDocumentPathCompatibility(SearchIndexNodeContext<?> left, SearchIndexNodeContext<?> right) {
        String rightNestedDocumentPathHierarchy;
        String leftNestedDocumentPathHierarchy = left.nestedDocumentPath();
        if (!Objects.equals(leftNestedDocumentPathHierarchy, rightNestedDocumentPathHierarchy = right.nestedDocumentPath())) {
            throw log.targetFieldsSpanningMultipleNestedPaths(left.absolutePath(), SearchIndexSchemaElementContextHelper.pathEventContext(leftNestedDocumentPathHierarchy), right.absolutePath(), SearchIndexSchemaElementContextHelper.pathEventContext(rightNestedDocumentPathHierarchy));
        }
    }

    private static EventContext pathEventContext(String path) {
        return path == null ? EventContexts.indexSchemaRoot() : EventContexts.fromIndexFieldAbsolutePath(path);
    }

    private SearchIndexSchemaElementContextHelper() {
    }

    public <T, SC extends SearchIndexScope<?>, N extends SearchIndexNodeContext<SC>> T queryElement(SearchQueryElementTypeKey<T> key, SearchQueryElementFactory<? extends T, ? super SC, ? super N> factory, SC scope, N node) {
        if (factory == null) {
            throw log.cannotUseQueryElementForIndexNode(node.relativeEventContext(), key, this.missingSupportHint(key), node.eventContext());
        }
        try {
            return factory.create(scope, node);
        }
        catch (SearchException e) {
            throw log.cannotUseQueryElementForIndexElementBecauseCreationException(node.relativeEventContext(), key, e.getMessage(), e, node.eventContext());
        }
    }

    protected abstract String missingSupportHint(SearchQueryElementTypeKey<?> var1);

    public abstract String partialSupportHint();
}

