/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.classpath.spi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Stream;
import org.hibernate.search.engine.environment.classpath.spi.AggregatedClassLoader;
import org.hibernate.search.engine.environment.classpath.spi.ServiceResolver;
import org.hibernate.search.util.common.AssertionFailure;

public abstract class DefaultServiceResolver
implements ServiceResolver {
    private static final Method SERVICE_LOADER_STREAM_METHOD;
    private static final Method PROVIDER_TYPE_METHOD;
    final AggregatedClassLoader aggregatedClassLoader;

    public static ServiceResolver create(AggregatedClassLoader aggregatedClassLoader) {
        if (SERVICE_LOADER_STREAM_METHOD != null) {
            return new ClassPathAndModulePathServiceResolver(aggregatedClassLoader);
        }
        return new ClassPathOnlyServiceResolver(aggregatedClassLoader);
    }

    private DefaultServiceResolver(AggregatedClassLoader aggregatedClassLoader) {
        this.aggregatedClassLoader = aggregatedClassLoader;
    }

    static {
        Class<ServiceLoader> serviceLoaderClass = ServiceLoader.class;
        Method serviceLoaderStreamMethod = null;
        Method providerTypeMethod = null;
        try {
            serviceLoaderStreamMethod = serviceLoaderClass.getMethod("stream", new Class[0]);
            Class<?> providerClass = Class.forName(serviceLoaderClass.getName() + "$Provider");
            providerTypeMethod = providerClass.getMethod("type", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        SERVICE_LOADER_STREAM_METHOD = serviceLoaderStreamMethod;
        PROVIDER_TYPE_METHOD = providerTypeMethod;
    }

    private static class ClassPathAndModulePathServiceResolver
    extends DefaultServiceResolver {
        private final List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();

        private ClassPathAndModulePathServiceResolver(AggregatedClassLoader aggregatedClassLoader) {
            super(aggregatedClassLoader);
            this.classLoaders.add(aggregatedClassLoader);
            aggregatedClassLoader.addAllTo(this.classLoaders);
        }

        public <S> Collection<S> loadJavaServices(Class<S> serviceContract) {
            LinkedHashSet alreadyUsedProviderTypes = new LinkedHashSet();
            LinkedHashSet services = new LinkedHashSet();
            this.classLoaders.stream().map(classLoader -> ServiceLoader.load(serviceContract, classLoader)).flatMap(delegate -> {
                try {
                    return (Stream)SERVICE_LOADER_STREAM_METHOD.invoke(delegate, new Object[0]);
                }
                catch (IllegalAccessException | RuntimeException | InvocationTargetException e) {
                    throw new AssertionFailure("Error calling ServiceLoader.stream()", (Throwable)e);
                }
            }).forEach(provider -> {
                Class type;
                try {
                    type = (Class)PROVIDER_TYPE_METHOD.invoke(provider, new Object[0]);
                }
                catch (IllegalAccessException | RuntimeException | InvocationTargetException e) {
                    throw new AssertionFailure("Error calling ServiceLoader.Provider.type()", (Throwable)e);
                }
                String typeName = type.getName();
                if (alreadyUsedProviderTypes.add(typeName)) {
                    services.add(provider.get());
                }
            });
            return services;
        }
    }

    private static class ClassPathOnlyServiceResolver
    extends DefaultServiceResolver {
        private ClassPathOnlyServiceResolver(AggregatedClassLoader aggregatedClassLoader) {
            super(aggregatedClassLoader);
        }

        public <S> Set<S> loadJavaServices(Class<S> serviceContract) {
            ServiceLoader<S> serviceLoader = ServiceLoader.load(serviceContract, this.aggregatedClassLoader);
            LinkedHashSet<S> services = new LinkedHashSet<S>();
            for (S service : serviceLoader) {
                services.add(service);
            }
            return services;
        }
    }
}

