/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.timeout.spi;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.engine.common.timing.spi.Deadline;
import org.hibernate.search.engine.common.timing.spi.TimingSource;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.search.util.common.impl.TimeHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class TimeoutManager {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final TimingSource timingSource;
    protected final Long timeoutValue;
    protected final TimeUnit timeoutUnit;
    protected final Long timeoutMs;
    protected final Type type;
    private final DynamicDeadline deadline;
    private Long monotonicTimeEstimateStart;
    private Long nanoTimeStart;

    public static TimeoutManager of(TimingSource timingSource, Long timeout, TimeUnit timeUnit, boolean exceptionOnTimeout) {
        if (timeout != null && timeUnit != null) {
            if (exceptionOnTimeout) {
                return TimeoutManager.hardTimeout(timingSource, timeout, timeUnit);
            }
            return TimeoutManager.softTimeout(timingSource, timeout, timeUnit);
        }
        return TimeoutManager.noTimeout(timingSource);
    }

    public static TimeoutManager noTimeout(TimingSource timingSource) {
        return new TimeoutManager(timingSource, null, null, Type.NONE);
    }

    public static TimeoutManager softTimeout(TimingSource timingSource, long timeout, TimeUnit timeUnit) {
        return new TimeoutManager(timingSource, timeout, timeUnit, Type.LIMIT);
    }

    public static TimeoutManager hardTimeout(TimingSource timingSource, long timeout, TimeUnit timeUnit) {
        return new TimeoutManager(timingSource, timeout, timeUnit, Type.EXCEPTION);
    }

    public TimeoutManager(TimingSource timingSource, Long timeoutValue, TimeUnit timeoutUnit, Type type) {
        this.timingSource = timingSource;
        this.timeoutValue = timeoutValue;
        this.timeoutUnit = timeoutUnit;
        this.timeoutMs = TimeHelper.toMillisecondsRoundedUp((Long)timeoutValue, (TimeUnit)timeoutUnit);
        this.type = type;
        DynamicDeadline dynamicDeadline = this.deadline = this.timeoutMs == null ? null : new DynamicDeadline();
        if (this.requireMonotonicTimeEstimate()) {
            timingSource.ensureTimeEstimateIsInitialized();
        }
    }

    public void start() {
        if (this.requireMonotonicTimeEstimate()) {
            this.monotonicTimeEstimateStart = this.timingSource.monotonicTimeEstimate();
        }
        this.nanoTimeStart = this.timingSource.nanoTime();
    }

    public void stop() {
        this.monotonicTimeEstimateStart = null;
        this.nanoTimeStart = null;
    }

    public TimingSource timingSource() {
        return this.timingSource;
    }

    public Deadline deadlineOrNull() {
        return this.deadline;
    }

    public Deadline hardDeadlineOrNull() {
        if (!this.hasHardTimeout()) {
            return null;
        }
        return this.deadline;
    }

    public long timeoutBaseline() {
        return this.monotonicTimeEstimateStart;
    }

    public boolean isTimedOut() {
        return this.deadline != null && this.deadline.timedOut;
    }

    public boolean checkTimedOut() {
        if (this.deadline == null) {
            return false;
        }
        return this.deadline.remainingTimeMillis() <= 0L;
    }

    public boolean hasHardTimeout() {
        return this.type == Type.EXCEPTION;
    }

    public Duration tookTime() {
        return Duration.ofNanos(this.timingSource.nanoTime() - this.nanoTimeStart);
    }

    protected long elapsedTimeEstimateMillis() {
        return this.timingSource.monotonicTimeEstimate() - this.monotonicTimeEstimateStart;
    }

    private boolean requireMonotonicTimeEstimate() {
        return !Type.NONE.equals((Object)this.type);
    }

    final class DynamicDeadline
    implements Deadline {
        boolean timedOut = false;

        DynamicDeadline() {
        }

        @Override
        public long remainingTimeMillis() {
            long elapsedTime = TimeoutManager.this.elapsedTimeEstimateMillis();
            long timeLeft = TimeoutManager.this.timeoutMs - elapsedTime;
            if (timeLeft <= 0L) {
                this.forceTimeout(null);
                return 0L;
            }
            return timeLeft;
        }

        @Override
        public void forceTimeout(Exception cause) {
            if (TimeoutManager.this.hasHardTimeout()) {
                throw this.forceTimeoutAndCreateException(cause);
            }
            this.timedOut = true;
        }

        @Override
        public SearchTimeoutException forceTimeoutAndCreateException(Exception cause) {
            this.timedOut = true;
            return log.timedOut(Duration.ofNanos(TimeoutManager.this.timeoutUnit.toNanos(TimeoutManager.this.timeoutValue)), cause);
        }
    }

    public static enum Type {
        NONE,
        EXCEPTION,
        LIMIT;

    }
}

