/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.types.converter.spi;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.spi.EventContextProvider;

public final class ProjectionConverter<F, V> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Class<V> valueType;
    private final FromDocumentFieldValueConverter<? super F, V> delegate;

    public ProjectionConverter(Class<V> valueType, FromDocumentFieldValueConverter<? super F, V> delegate) {
        Contracts.assertNotNull(valueType, (String)"valueType");
        Contracts.assertNotNull(delegate, (String)"delegate");
        this.valueType = valueType;
        this.delegate = delegate;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[valueType=" + this.valueType.getName() + ",delegate=" + this.delegate + "]";
    }

    public Class<V> valueType() {
        return this.valueType;
    }

    public V convert(F value, FromDocumentFieldValueConvertContext context) {
        return this.delegate.convert(value, context);
    }

    public <T> ProjectionConverter<F, ? extends T> withConvertedType(Class<T> expectedType, EventContextProvider eventContextProvider) {
        if (!expectedType.isAssignableFrom(this.valueType)) {
            throw log.invalidOutputTypeForField(expectedType, this.valueType, eventContextProvider.eventContext());
        }
        return this;
    }

    public boolean isCompatibleWith(ProjectionConverter<?, ?> other) {
        return this.delegate.isCompatibleWith(other.delegate);
    }
}

