/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.building.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class PathFilter {
    private static final PathFilter UNCONSTRAINED = new PathFilter(Collections.emptySet());
    private final Set<String> includedPaths;

    static PathFilter unconstrained() {
        return UNCONSTRAINED;
    }

    static PathFilter of(Set<String> paths) {
        if (paths == null || paths.isEmpty()) {
            return PathFilter.unconstrained();
        }
        HashSet<String> includedPaths = new HashSet<String>();
        for (String path : paths) {
            includedPaths.add(path);
            PathFilter.addSubPathsFromRoot(includedPaths, path);
        }
        return new PathFilter(includedPaths);
    }

    private PathFilter(Set<String> includedPaths) {
        this.includedPaths = includedPaths;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[includedPaths=" + this.includedPaths + "]";
    }

    boolean isExplicitlyIncluded(String relativePath) {
        return this.includedPaths.contains(relativePath);
    }

    boolean isAnyPathExplicitlyIncluded() {
        return !this.includedPaths.isEmpty();
    }

    private static void addSubPathsFromRoot(Set<String> collector, String path) {
        int afterPreviousDotIndex = 0;
        int nextDotIndex = path.indexOf(46, afterPreviousDotIndex);
        while (nextDotIndex >= 0) {
            String subPath = path.substring(0, nextDotIndex);
            collector.add(subPath);
            afterPreviousDotIndex = nextDotIndex + 1;
            nextDotIndex = path.indexOf(46, afterPreviousDotIndex);
        }
    }
}

