/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.building.spi;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;

public final class IndexedEmbeddedDefinition {
    private final MappableTypeModel definingTypeModel;
    private final String relativePrefix;
    private final ObjectStructure structure;
    private final Set<String> includePaths;
    private final Integer includeDepth;

    public IndexedEmbeddedDefinition(MappableTypeModel definingTypeModel, String relativePrefix, ObjectStructure structure, Integer includeDepth, Set<String> includePaths) {
        this.definingTypeModel = definingTypeModel;
        this.relativePrefix = relativePrefix;
        this.structure = structure;
        this.includePaths = includePaths == null ? Collections.emptySet() : new LinkedHashSet<String>(includePaths);
        this.includeDepth = includeDepth == null && !this.includePaths.isEmpty() ? Integer.valueOf(0) : includeDepth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexedEmbeddedDefinition that = (IndexedEmbeddedDefinition)o;
        return this.definingTypeModel.equals(that.definingTypeModel) && this.relativePrefix.equals(that.relativePrefix) && Objects.equals(this.includeDepth, that.includeDepth) && this.includePaths.equals(that.includePaths);
    }

    public int hashCode() {
        return Objects.hash(this.definingTypeModel, this.relativePrefix, this.includeDepth, this.includePaths);
    }

    public MappableTypeModel definingTypeModel() {
        return this.definingTypeModel;
    }

    public String relativePrefix() {
        return this.relativePrefix;
    }

    public ObjectStructure structure() {
        return this.structure;
    }

    public Set<String> includePaths() {
        return this.includePaths;
    }

    public Integer includeDepth() {
        return this.includeDepth;
    }
}

