/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.hibernate.search.engine.backend.Backend;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.common.impl.MappingPreStopContextImpl;
import org.hibernate.search.engine.common.resources.impl.EngineThreads;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.common.timing.spi.TimingSource;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;
import org.hibernate.search.engine.environment.thread.impl.ThreadPoolProviderImpl;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingKey;
import org.hibernate.search.engine.mapper.mapping.spi.MappingImplementor;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.impl.EngineEventContextMessages;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.engine.reporting.spi.RootFailureCollector;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContextElement;

public class SearchIntegrationImpl
implements SearchIntegration {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BeanProvider beanProvider;
    private final BeanHolder<? extends FailureHandler> failureHandlerHolder;
    private final ThreadPoolProviderImpl threadPoolProvider;
    private final Map<MappingKey<?, ?>, MappingImplementor<?>> mappings;
    private final Map<String, BackendImplementor> backends;
    private final Map<String, IndexManagerImplementor> indexManagers;
    private final EngineThreads engineThreads;
    private final TimingSource timingSource;

    SearchIntegrationImpl(BeanProvider beanProvider, BeanHolder<? extends FailureHandler> failureHandlerHolder, ThreadPoolProviderImpl threadPoolProvider, Map<MappingKey<?, ?>, MappingImplementor<?>> mappings, Map<String, BackendImplementor> backends, Map<String, IndexManagerImplementor> indexManagers, EngineThreads engineThreads, TimingSource timingSource) {
        this.beanProvider = beanProvider;
        this.failureHandlerHolder = failureHandlerHolder;
        this.threadPoolProvider = threadPoolProvider;
        this.mappings = mappings;
        this.backends = backends;
        this.indexManagers = indexManagers;
        this.engineThreads = engineThreads;
        this.timingSource = timingSource;
    }

    @Override
    public Backend backend() {
        BackendImplementor backend = this.backends.get(null);
        if (backend == null) {
            throw log.noDefaultBackendRegistered();
        }
        return backend.toAPI();
    }

    @Override
    public Backend backend(String backendName) {
        BackendImplementor backend = this.backends.get(backendName);
        if (backend == null) {
            throw log.noBackendRegistered(backendName);
        }
        return backend.toAPI();
    }

    @Override
    public IndexManager indexManager(String indexManagerName) {
        IndexManagerImplementor indexManager = this.indexManagers.get(indexManagerName);
        if (indexManager == null) {
            throw log.noIndexManagerRegistered(indexManagerName);
        }
        return indexManager.toAPI();
    }

    @Override
    public void close() {
        RootFailureCollector rootFailureCollector = new RootFailureCollector(EngineEventContextMessages.INSTANCE.shutdown());
        this.stopAllSafelyInParallel(this.mappings, (mapping, contextualFailureCollector) -> {
            MappingPreStopContextImpl preStopContext = new MappingPreStopContextImpl((ContextualFailureCollector)contextualFailureCollector);
            return mapping.preStop(preStopContext);
        }, rootFailureCollector, (failureCollector, mappingKey) -> failureCollector.withContext((EventContextElement)mappingKey));
        this.stopAllSafely(this.mappings, (mapping, ignored) -> mapping.stop(), rootFailureCollector, (failureCollector, mappingKey) -> failureCollector.withContext((EventContextElement)mappingKey));
        this.stopAllSafelyInParallel(this.indexManagers, (indexManager, contextualFailureCollector) -> indexManager.preStop(), rootFailureCollector, (failureCollector, name) -> failureCollector.withContext(EventContexts.fromIndexName(name)));
        this.stopAllSafely(this.indexManagers, (indexManager, contextualFailureCollector) -> indexManager.stop(), rootFailureCollector, (failureCollector, name) -> failureCollector.withContext(EventContexts.fromIndexName(name)));
        this.stopAllSafely(this.backends, (backend, contextualFailureCollector) -> backend.stop(), rootFailureCollector, (failureCollector, name) -> failureCollector.withContext(EventContexts.fromBackendName(name)));
        try (Closer closer = new Closer();){
            closer.pushAll(ThreadPoolProviderImpl::close, (Object[])new ThreadPoolProviderImpl[]{this.threadPoolProvider});
            closer.pushAll(BeanHolder::close, (Object[])new BeanHolder[]{this.failureHandlerHolder});
            closer.pushAll(BeanProvider::close, (Object[])new BeanProvider[]{this.beanProvider});
            closer.pushAll(EngineThreads::onStop, (Object[])new EngineThreads[]{this.engineThreads});
            closer.pushAll(TimingSource::stop, (Object[])new TimingSource[]{this.timingSource});
        }
        catch (RuntimeException e) {
            rootFailureCollector.withContext(EventContexts.defaultContext()).add(e);
        }
        rootFailureCollector.checkNoFailure();
    }

    private <K, V> void stopAllSafely(Map<K, V> map, BiConsumer<V, ContextualFailureCollector> stop, FailureCollector failureCollector, BiFunction<FailureCollector, K, ContextualFailureCollector> appendEventContext) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            ContextualFailureCollector contextualFailureCollector = appendEventContext.apply(failureCollector, entry.getKey());
            try {
                stop.accept(entry.getValue(), contextualFailureCollector);
            }
            catch (RuntimeException e) {
                contextualFailureCollector.add(e);
            }
        }
    }

    private <K, V> void stopAllSafelyInParallel(Map<K, V> map, BiFunction<V, ContextualFailureCollector, CompletableFuture<?>> stop, FailureCollector failureCollector, BiFunction<FailureCollector, K, ContextualFailureCollector> appendEventContext) {
        CompletableFuture[] futures = new CompletableFuture[map.size()];
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            ContextualFailureCollector contextualFailureCollector = appendEventContext.apply(failureCollector, entry.getKey());
            futures[i] = Futures.create(() -> (CompletableFuture)stop.apply(entry.getValue(), contextualFailureCollector)).exceptionally(Futures.handler(throwable -> {
                Exception exception = Throwables.expectException((Throwable)throwable);
                contextualFailureCollector.add(exception);
                return null;
            }));
            ++i;
        }
        Futures.unwrappedExceptionJoin(CompletableFuture.allOf(futures));
    }
}

